/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.push.ConfirmationPage;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushTagsPage;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PushTagsWizard
extends Wizard {
    private final Repository repository;
    private final PushTagsPage pushTagsPage;
    private final ConfirmationPage confirmationPage;

    public static void openWizardDialog(final Repository repository, final String ... tagNames) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PushTagsWizard wizard = new PushTagsWizard(repository, Arrays.asList(tagNames));
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.setHelpAvailable(false);
                dialog.open();
            }
        });
    }

    public PushTagsWizard(Repository repository, Collection<String> tagNamesToSelect) {
        this.repository = repository;
        this.pushTagsPage = new PushTagsPage(repository, tagNamesToSelect);
        this.confirmationPage = new ConfirmationPage(repository){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(PushTagsWizard.this.getRepositorySelection(), PushTagsWizard.this.getRefSpecs());
                }
                super.setVisible(visible);
            }
        };
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_PUSH);
    }

    public String getWindowTitle() {
        return UIText.PushTagsWizard_WindowTitle;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.pushTagsPage);
        this.addPage((IWizardPage)this.confirmationPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.pushTagsPage) {
            return this.confirmationPage;
        }
        return null;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.confirmationPage;
    }

    public boolean performFinish() {
        try {
            this.startPush();
            return true;
        }
        catch (IOException e) {
            this.confirmationPage.setErrorMessage(e.getMessage());
            return false;
        }
    }

    private RepositorySelection getRepositorySelection() {
        return new RepositorySelection(null, this.pushTagsPage.getSelectedRemoteConfig());
    }

    private List<RefSpec> getRefSpecs() {
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        String prefix = this.pushTagsPage.isForceUpdateSelected() ? "+" : "";
        for (TagNode tag : this.pushTagsPage.getSelectedTags()) {
            String refName = ((Ref)tag.getObject()).getName();
            RefSpec spec = new RefSpec(prefix + refName);
            specs.add(spec);
        }
        return specs;
    }

    private void startPush() throws IOException {
        PushOperationResult result = this.confirmationPage.getConfirmedResult();
        PushOperationSpecification pushSpec = result.deriveSpecification(this.confirmationPage.isRequireUnchangedSelected());
        PushOperationUI pushOperationUI = new PushOperationUI(this.repository, pushSpec, false);
        pushOperationUI.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        pushOperationUI.setShowConfigureButton(false);
        if (this.confirmationPage.isShowOnlyIfChangedSelected()) {
            pushOperationUI.setExpectedResult(this.confirmationPage.getConfirmedResult());
        }
        pushOperationUI.start();
    }
}

