/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Messages;
import org.eclipse.jst.server.core.internal.RuntimeClasspathContainer;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class RuntimeClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            String runtimeId = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
            }
            RuntimeClasspathContainer container = new RuntimeClasspathContainer(project.getProject(), containerPath, delegate, runtime, runtimeId);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        return Messages.classpathContainerDescription;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals("org.eclipse.jst.server.core.container")) {
            RuntimeClasspathProviderWrapper delegate = null;
            IRuntime runtime = null;
            if (containerPath.segmentCount() > 2) {
                delegate = JavaServerPlugin.findRuntimeClasspathProvider(containerPath.segment(1));
                String runtimeId = containerPath.segment(2);
                if (runtimeId != null) {
                    runtime = ServerCore.findRuntime((String)runtimeId);
                }
                delegate.requestClasspathContainerUpdate(runtime, containerSuggestion.getClasspathEntries());
                RuntimeClasspathContainerInitializer.updateClasspath(runtime, containerPath, containerSuggestion);
            }
        }
    }

    public static void updateClasspath(IRuntime runtime, IPath containerPath, IClasspathContainer containerSuggestion) {
        class UpdateClasspathJob
        extends Job {
            private final /* synthetic */ IPath val$containerPath;
            private final /* synthetic */ IClasspathContainer val$containerSuggestion;

            public UpdateClasspathJob(IRuntime iRuntime, IPath iPath, IClasspathContainer iClasspathContainer) {
                this.val$containerPath = iPath;
                this.val$containerSuggestion = iClasspathContainer;
                super(NLS.bind((String)Messages.updateClasspathContainers, (Object)iRuntime.getName()));
            }

            public boolean belongsTo(Object family) {
                return ServerUtil.SERVER_JOB_FAMILY.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                int size;
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
                if (projects != null) {
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block14: {
                            IProject project = iProjectArray[n2];
                            if (project.isAccessible()) {
                                try {
                                    if (project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
                                        IClasspathEntry[] ce;
                                        IJavaProject javaProject = JavaCore.create((IProject)project);
                                        boolean found = false;
                                        IClasspathEntry[] iClasspathEntryArray = ce = javaProject.getRawClasspath();
                                        int n3 = ce.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            IClasspathEntry cp = iClasspathEntryArray[n4];
                                            if (cp.getEntryKind() == 5 && this.val$containerPath.isPrefixOf(cp.getPath())) {
                                                found = true;
                                            }
                                            ++n4;
                                        }
                                        if (Trace.FINEST) {
                                            Trace.trace("/finest", "Classpath change on: " + String.valueOf(project) + " " + found);
                                        }
                                        if (found) {
                                            list.add(javaProject);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    if (!Trace.SEVERE) break block14;
                                    Trace.trace("/severe", "Could not update classpath container", e);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if ((size = list.size()) > 0) {
                    IJavaProject[] javaProjects = new IJavaProject[size];
                    list.toArray(javaProjects);
                    IClasspathContainer[] containers = new IClasspathContainer[size];
                    int i = 0;
                    while (i < size) {
                        containers[i] = this.val$containerSuggestion;
                        ++i;
                    }
                    try {
                        JavaCore.setClasspathContainer((IPath)this.val$containerPath, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
                    }
                    catch (JavaModelException jme) {
                        return jme.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        }
        UpdateClasspathJob job = new UpdateClasspathJob(runtime, containerPath, containerSuggestion);
        job.schedule();
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return containerPath.toPortableString();
    }
}

