/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.util.Preconditions;

public abstract class MarkupLanguageProvider {
    public final Set<MarkupLanguage> getMarkupLanguages() {
        Set<MarkupLanguage> languages = Set.copyOf((Collection)Objects.requireNonNull(this.loadMarkupLanguages(), "loadMarkupLanguages() must not return null"));
        this.assertLanguageNames(languages);
        return languages;
    }

    private void assertLanguageNames(Set<MarkupLanguage> languages) {
        HashSet<String> names = new HashSet<String>();
        for (MarkupLanguage language : languages) {
            Objects.requireNonNull(language.getName(), "Provided languages must have a name");
            Preconditions.checkState(names.add(language.getName()), "Language name '%s' must not be provided more than once", language.getName());
        }
    }

    protected abstract Set<MarkupLanguage> loadMarkupLanguages();
}

