/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.pty;

import java.io.IOException;
import org.eclipse.cdt.utils.pty.ConPTY;
import org.eclipse.cdt.utils.pty.PTYOutputStream;

public class ConPTYOutputStream
extends PTYOutputStream {
    private ConPTY conPty;

    public ConPTYOutputStream(ConPTY conPty) {
        super(null, false);
        this.conPty = conPty;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, 0, len);
        this.conPty.write(tmpBuf);
    }

    @Override
    public void close() throws IOException {
        if (this.conPty == null) {
            return;
        }
        try {
            this.conPty.close();
        }
        finally {
            this.conPty = null;
        }
    }
}

