/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.security.PermissionUtil;
import org.eclipse.emf.cdo.internal.security.bundle.OM;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.internal.cdo.CDOObjectImpl;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class PermissionFilterImpl
extends CDOObjectImpl
implements PermissionFilter {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, PermissionFilterImpl.class);

    protected PermissionFilterImpl() {
    }

    protected EClass eStaticClass() {
        return SecurityPackage.Literals.PERMISSION_FILTER;
    }

    protected int eStaticFeatureCount() {
        return 0;
    }

    @Override
    public boolean isApplicable(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, int level) throws Exception {
        String msg = StringUtil.NL;
        boolean tracing = TRACER.isEnabled();
        if (tracing) {
            msg = String.valueOf(StringUtil.create((char)' ', (int)(level << 1))) + this.getClass().getSimpleName() + ": " + this.format();
            TRACER.trace(msg);
        }
        boolean result = false;
        try {
            try {
                result = this.filter(revision, revisionProvider, securityContext, level);
            }
            catch (Exception ex) {
                if (tracing) {
                    TRACER.trace((Throwable)ex);
                }
                if (tracing) {
                    TRACER.trace(String.valueOf(msg) + " = " + result);
                }
            }
        }
        finally {
            if (tracing) {
                TRACER.trace(String.valueOf(msg) + " = " + result);
            }
        }
        return result;
    }

    protected abstract boolean filter(CDORevision var1, CDORevisionProvider var2, CDOBranchPoint var3, int var4) throws Exception;

    protected final String getUser() {
        return PermissionUtil.getUser();
    }
}

