/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    private EditorUtility() {
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static IOpenable getJavaInput(IEditorPart part) {
        IJavaElement input;
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput != null && (input = EditorUtility.javaUIgetEditorInputJavaElement(editorInput)) instanceof IOpenable) {
            return (IOpenable)input;
        }
        return null;
    }

    private static IJavaElement javaUIgetEditorInputJavaElement(IEditorInput editorInput) {
        Assert.isNotNull((Object)editorInput);
        ICompilationUnit je = JavaUI.getWorkingCopyManager().getWorkingCopy(editorInput);
        if (je != null) {
            return je;
        }
        return (IJavaElement)editorInput.getAdapter(IJavaElement.class);
    }

    public static void selectInEditor(ITextEditor editor, int offset, int length) {
        IEditorPart active = EditorUtility.getActiveEditor();
        if (active != editor) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
        }
        editor.selectAndReveal(offset, length);
    }
}

