/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.storage.WorkspaceFileRevision;
import org.eclipse.jgit.lib.Repository;
import org.osgi.framework.Version;

public class EGitCompatibilityUtil {
    public static final Version EGIT_5_11 = new Version(5, 11, 0);
    public static final Version EGIT_5_12 = new Version(5, 12, 0);
    public static final Version EGIT_6_0 = new Version(6, 0, 0);

    public static RepositoryUtil getRepositoryUtil() {
        if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGIT_6_0) >= 0) {
            return RepositoryUtil.INSTANCE;
        }
        if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGIT_5_11) >= 0) {
            return (RepositoryUtil)EGitCompatibilityUtil.invoke(RepositoryUtil.class, null, "getInstance");
        }
        Activator activator = Activator.getDefault();
        return (RepositoryUtil)EGitCompatibilityUtil.invoke(Activator.class, activator, "getRepositoryUtil");
    }

    public static IndexDiffCache getIndexDiffCache() {
        if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGIT_6_0) >= 0) {
            return IndexDiffCache.INSTANCE;
        }
        if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGIT_5_11) >= 0) {
            return (IndexDiffCache)EGitCompatibilityUtil.invoke(IndexDiffCache.class, null, "getInstance");
        }
        Activator activator = Activator.getDefault();
        return (IndexDiffCache)EGitCompatibilityUtil.invoke(Activator.class, activator, "getIndexDiffCache");
    }

    public static WorkspaceFileRevision createWorkspaceFileRevision(Repository repo, IResource local) {
        if (EGitCompatibilityUtil.getEGitVersion().compareTo(EGIT_6_0) >= 0) {
            return WorkspaceFileRevision.forFile((Repository)repo, (IResource)local);
        }
        try {
            Constructor constructor = WorkspaceFileRevision.class.getConstructor(IResource.class);
            return (WorkspaceFileRevision)constructor.newInstance(local);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static Version getEGitVersion() {
        return Platform.getBundle((String)"org.eclipse.egit.ui").getVersion();
    }

    public static Object invoke(Class<?> targetClass, Object target, String methodName) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }
}

