/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.ResolutionReportListener;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.resolver.ResolutionException;

class ConfigApplier {
    private static final String LAST_BUNDLES_INFO = "last.bundles.info";
    private static final String PROP_DEVMODE = "osgi.dev";
    private final BundleContext manipulatingContext;
    private final FrameworkWiring frameworkWiring;
    private final boolean runningOnEquinox;
    private final boolean inDevMode;
    private final Bundle callingBundle;
    private final URI baseLocation;
    private final boolean deepRefresh;
    private int maxRefreshTry;
    private Bundle systemBundle;

    ConfigApplier(BundleContext context, Bundle callingBundle) {
        this.deepRefresh = Boolean.parseBoolean(context.getProperty("equinox.simpleconfigurator.deeprefresh"));
        String maxRefreshValue = context.getProperty("equinox.simpleconfigurator.maxrefresh");
        this.maxRefreshTry = maxRefreshValue != null ? Integer.parseInt(maxRefreshValue) : 10;
        this.manipulatingContext = context;
        this.callingBundle = callingBundle;
        this.runningOnEquinox = "Eclipse".equals(context.getProperty("org.osgi.framework.vendor"));
        this.inDevMode = this.manipulatingContext.getProperty(PROP_DEVMODE) != null;
        this.baseLocation = this.runningOnEquinox ? EquinoxUtils.getInstallLocationURI(context) : null;
        this.systemBundle = this.manipulatingContext.getBundle("System Bundle");
        this.frameworkWiring = (FrameworkWiring)this.systemBundle.adapt(FrameworkWiring.class);
    }

    void install(URL url, boolean exclusiveMode) throws IOException {
        List<BundleInfo> bundleInfoList = SimpleConfiguratorUtils.readConfiguration(url, this.baseLocation);
        if (Activator.DEBUG) {
            System.out.println("applyConfiguration() bundleInfoList.size()=" + bundleInfoList.size());
        }
        if (bundleInfoList.size() == 0) {
            return;
        }
        BundleInfo[] expectedState = Utils.getBundleInfosFromList(bundleInfoList);
        String systemBundleSymbolicName = this.manipulatingContext.getBundle(0L).getSymbolicName();
        Version systemBundleVersion = this.manipulatingContext.getBundle(0L).getVersion();
        if (systemBundleSymbolicName != null) {
            BundleInfo[] bundleInfoArray = expectedState;
            int n = expectedState.length;
            int n2 = 0;
            while (n2 < n) {
                Version version;
                BundleInfo element = bundleInfoArray[n2];
                String symbolicName = element.getSymbolicName();
                if (systemBundleSymbolicName.equals(symbolicName) && !systemBundleVersion.equals((Object)(version = Version.parseVersion((String)element.getVersion())))) {
                    throw new IllegalStateException("The System Bundle was updated. The framework must be restarted to finalize the configuration change");
                }
                ++n2;
            }
        }
        HashSet<BundleInfo> toUninstall = null;
        if (!exclusiveMode) {
            BundleInfo[] lastInstalledBundles = this.getLastState();
            if (lastInstalledBundles != null) {
                toUninstall = new HashSet<BundleInfo>(Arrays.asList(lastInstalledBundles));
                toUninstall.removeAll(Arrays.asList(expectedState));
            }
            this.saveStateAsLast(url);
        }
        Set<Bundle> prevouslyResolved = this.getResolvedBundles();
        LinkedHashSet<Bundle> toRefresh = new LinkedHashSet<Bundle>();
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        if (exclusiveMode) {
            toRefresh.addAll(this.installBundles(expectedState, toStart));
            toRefresh.addAll(this.uninstallBundles(expectedState));
        } else {
            toRefresh.addAll(this.installBundles(expectedState, toStart));
            if (toUninstall != null) {
                toRefresh.addAll(this.uninstallBundles(toUninstall));
            }
        }
        if (!toRefresh.isEmpty()) {
            if (this.manipulatingContext.getBundle().getState() == 8) {
                this.refreshAllBundles();
            } else {
                Map<String, List<Bundle>> bundlesByBsn = Arrays.stream(this.manipulatingContext.getBundles()).filter(bundle -> bundle.getSymbolicName() != null).collect(Collectors.groupingBy(Bundle::getSymbolicName));
                LinkedHashSet<Bundle> allSameBSNs = new LinkedHashSet<Bundle>();
                for (Bundle bundle2 : toRefresh) {
                    allSameBSNs.addAll((Collection<Bundle>)bundlesByBsn.getOrDefault(bundle2.getSymbolicName(), List.of(bundle2)));
                }
                this.refreshPackages(allSameBSNs);
                this.refreshPackages(this.getAdditionalRefresh(prevouslyResolved, toRefresh));
            }
            if (this.deepRefresh) {
                Collection<Bundle> provider;
                HashSet<Bundle> bundlesTried = new HashSet<Bundle>();
                Set<Bundle> doNotRefresh = this.getDoNotRefresh();
                int maxtry = this.maxRefreshTry;
                while (!(provider = this.getUnresolvedRequirementsProvider(doNotRefresh)).isEmpty() && bundlesTried.addAll(provider)) {
                    if (Activator.DEBUG) {
                        System.out.println("There are " + provider.size() + " bundles to refresh...");
                        for (Bundle bundle3 : provider) {
                            System.out.println("\t" + bundle3.getSymbolicName() + " " + String.valueOf(bundle3.getVersion()));
                        }
                    }
                    CountDownLatch latch = new CountDownLatch(1);
                    this.frameworkWiring.refreshBundles(provider, new FrameworkListener[]{event -> {
                        if (event.getType() == 4) {
                            latch.countDown();
                        }
                    }});
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (maxtry-- > 0) continue;
                }
            }
        }
        this.startBundles(toStart.toArray(new Bundle[toStart.size()]));
    }

    private Collection<Bundle> getUnresolvedRequirementsProvider(Set<Bundle> doNotRefresh) {
        ResolutionReportListener reportListener = new ResolutionReportListener();
        ServiceRegistration hookReg = this.manipulatingContext.registerService(ResolverHookFactory.class, (Object)reportListener, null);
        try {
            if (this.frameworkWiring.resolveBundles(null)) {
                List<Bundle> list = List.of();
                return list;
            }
            if (Activator.DEBUG) {
                System.out.println("There are unresolved bundles...");
            }
        }
        finally {
            hookReg.unregister();
        }
        return reportListener.getReports().stream().flatMap(rr -> rr.getEntries().values().stream().flatMap(Collection::stream)).flatMap(error -> {
            Requirement requirement;
            if (error.getType() == ResolutionReport.Entry.Type.MISSING_CAPABILITY && !"optional".equals((requirement = (Requirement)error.getData()).getDirectives().get("resolution"))) {
                return Stream.of(requirement);
            }
            if (error.getType() == ResolutionReport.Entry.Type.USES_CONSTRAINT_VIOLATION) {
                ResolutionException ex = (ResolutionException)error.getData();
                return ex.getUnresolvedRequirements().stream();
            }
            return Stream.empty();
        }).distinct().flatMap(req -> this.frameworkWiring.findProviders(req).stream()).map(bc -> bc.getResource().getBundle()).distinct().filter(bundle -> !doNotRefresh.contains(bundle)).toList();
    }

    private Collection<Bundle> getAdditionalRefresh(Set<Bundle> previouslyResolved, Collection<Bundle> toRefresh) {
        BundleRevision revision;
        HashSet<Bundle> additionalRefresh = new HashSet<Bundle>();
        for (Bundle bundle : toRefresh) {
            revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (bundle.getState() != 2 || revision == null || (revision.getTypes() & 1) == 0) continue;
            boolean foundPayLoadReq = false;
            BundleRequirement hostReq = null;
            List requirements = revision.getRequirements(null);
            for (Requirement requirement : requirements) {
                BundleRequirement req = (BundleRequirement)requirement;
                if ("osgi.wiring.host".equals(req.getNamespace())) {
                    hostReq = req;
                }
                if ("osgi.wiring.host".equals(req.getNamespace()) || "osgi.ee".equals(req.getNamespace())) continue;
                foundPayLoadReq = true;
            }
            if (!foundPayLoadReq) continue;
            Collection candidates = this.frameworkWiring.findProviders(hostReq);
            for (BundleCapability candidate : candidates) {
                if (toRefresh.contains(candidate.getRevision().getBundle())) continue;
                additionalRefresh.add(candidate.getRevision().getBundle());
            }
        }
        block3: for (Bundle bundle : previouslyResolved) {
            BundleWiring wiring;
            revision = (BundleRevision)bundle.adapt(BundleRevision.class);
            BundleWiring bundleWiring = wiring = revision == null ? null : revision.getWiring();
            if (wiring == null) continue;
            List reqs = revision.getDeclaredRequirements(null);
            HashSet<BundleRequirement> optionalReqs = new HashSet<BundleRequirement>();
            for (BundleRequirement req : reqs) {
                String namespace = req.getNamespace();
                if (!"osgi.wiring.package".equals(namespace) && !"osgi.wiring.bundle".equals(namespace) || !"optional".equals(req.getDirectives().get("resolution"))) continue;
                optionalReqs.add(req);
            }
            if (optionalReqs.isEmpty()) continue;
            wiring = this.getHostWiring(wiring);
            List requiredWires = wiring.getRequiredWires(null);
            for (BundleWire requiredWire : requiredWires) {
                optionalReqs.remove(requiredWire.getRequirement());
            }
            if (optionalReqs.isEmpty()) continue;
            for (BundleRequirement bundleRequirement : optionalReqs) {
                Collection candidates = this.frameworkWiring.findProviders((Requirement)bundleRequirement);
                Iterator iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    BundleCapability candidate = (BundleCapability)iCandidates.next();
                    Bundle candidateBundle = candidate.getRevision().getBundle();
                    if (!previouslyResolved.contains(candidateBundle) && candidateBundle.getState() != 2) continue;
                    iCandidates.remove();
                }
                if (candidates.isEmpty()) continue;
                additionalRefresh.add(wiring.getBundle());
                continue block3;
            }
        }
        return additionalRefresh;
    }

    private BundleWiring getHostWiring(BundleWiring wiring) {
        if ((wiring.getRevision().getTypes() & 1) == 0) {
            return wiring;
        }
        List hostWires = wiring.getRequiredWires("osgi.wiring.host");
        if (hostWires.isEmpty()) {
            return wiring;
        }
        BundleWire hostWire = (BundleWire)hostWires.iterator().next();
        return hostWire.getProviderWiring();
    }

    private Set<Bundle> getResolvedBundles() {
        Bundle[] allBundles;
        HashSet<Bundle> resolved = new HashSet<Bundle>();
        Bundle[] bundleArray = allBundles = this.manipulatingContext.getBundles();
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                resolved.add(bundle);
            }
            ++n2;
        }
        return resolved;
    }

    private void refreshAllBundles() {
        HashSet<Bundle> toRefresh = new HashSet<Bundle>(this.frameworkWiring.getRemovalPendingBundles());
        Set<Bundle> doNotRefresh = this.getDoNotRefresh();
        Bundle[] bundleArray = this.manipulatingContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (!doNotRefresh.contains(bundle)) {
                toRefresh.add(bundle);
            }
            ++n2;
        }
        this.refreshPackages(toRefresh);
    }

    private Set<Bundle> getDoNotRefresh() {
        HashSet<Bundle> doNotRefresh = new HashSet<Bundle>();
        Bundle thisBundle = this.manipulatingContext.getBundle();
        if (thisBundle != null) {
            doNotRefresh.add(thisBundle);
            this.addDoNotRefreshFragments(thisBundle, doNotRefresh);
        }
        Bundle systemBundle = this.manipulatingContext.getBundle("System Bundle");
        doNotRefresh.add(systemBundle);
        this.addDoNotRefreshFragments(systemBundle, doNotRefresh);
        return doNotRefresh;
    }

    private void addDoNotRefreshFragments(Bundle bundle, Set<Bundle> doNotRefresh) {
        BundleWiring systemWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (systemWiring != null) {
            for (BundleWire hostWire : systemWiring.getProvidedWires("osgi.wiring.host")) {
                Bundle systemFragment = hostWire.getRequirer().getBundle();
                if (systemFragment.getState() == 1 || systemFragment.adapt(BundleWiring.class) == null) continue;
                doNotRefresh.add(systemFragment);
            }
        }
    }

    private Collection<Bundle> uninstallBundles(HashSet<BundleInfo> toUninstall) {
        ArrayList<Bundle> removedBundles = new ArrayList<Bundle>(toUninstall.size());
        for (BundleInfo current : toUninstall) {
            Bundle[] matchingBundles = this.getBundles(current.getSymbolicName(), this.getVersionRange(current.getVersion()));
            int j = 0;
            while (matchingBundles != null && j < matchingBundles.length) {
                try {
                    removedBundles.add(matchingBundles[j]);
                    matchingBundles[j].uninstall();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
                ++j;
            }
        }
        return removedBundles;
    }

    private void saveStateAsLast(URL url) {
        File lastBundlesTxt = this.getLastBundleInfo();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileOutputStream destinationStream = new FileOutputStream(lastBundlesTxt);){
                ArrayList<File> sourcesLocation = SimpleConfiguratorUtils.getInfoFiles();
                ArrayList<InputStream> sourceStreams = new ArrayList<InputStream>(sourcesLocation.size() + 1);
                sourceStreams.add(url.openStream());
                if (Activator.EXTENDED) {
                    for (File source : sourcesLocation) {
                        sourceStreams.add(new FileInputStream(source));
                    }
                }
                SimpleConfiguratorUtils.transferStreams(sourceStreams, destinationStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getLastBundleInfo() {
        return this.manipulatingContext.getDataFile(LAST_BUNDLES_INFO);
    }

    private BundleInfo[] getLastState() {
        File lastBundlesInfo = this.getLastBundleInfo();
        if (!lastBundlesInfo.isFile()) {
            return null;
        }
        try {
            return SimpleConfiguratorUtils.readConfiguration(lastBundlesInfo.toURL(), this.baseLocation).toArray(new BundleInfo[1]);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ArrayList<Bundle> installBundles(BundleInfo[] finalList, Collection<Bundle> toStart) {
        ArrayList<Bundle> toRefresh = new ArrayList<Bundle>();
        String useReferenceProperty = this.manipulatingContext.getProperty("org.eclipse.equinox.simpleconfigurator.useReference");
        boolean useReference = useReferenceProperty == null ? this.runningOnEquinox : Boolean.parseBoolean(useReferenceProperty);
        BundleInfo[] bundleInfoArray = finalList;
        int n = finalList.length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                BundleInfo element = bundleInfoArray[n2];
                if (element != null) {
                    int startLevel;
                    Bundle current;
                    block25: {
                        String symbolicName = element.getSymbolicName();
                        String version = element.getVersion();
                        Bundle[] matches = null;
                        if (symbolicName != null && version != null) {
                            matches = this.getBundles(symbolicName, this.getVersionRange(version));
                        }
                        String bundleLocation = SimpleConfiguratorUtils.getBundleLocation(element, useReference);
                        Bundle bundle = matches == null ? null : (current = matches.length == 0 ? null : matches[0]);
                        if (current == null) {
                            try {
                                block24: {
                                    current = this.manipulatingContext.installBundle(bundleLocation);
                                    if (symbolicName != null && version != null) {
                                        try {
                                            Version v = new Version(version);
                                            if (!symbolicName.equals(current.getSymbolicName()) || !v.equals((Object)current.getVersion())) {
                                                current.update();
                                            }
                                        }
                                        catch (IllegalArgumentException e) {
                                            if (!Activator.DEBUG) break block24;
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                if (Activator.DEBUG) {
                                    System.out.println("installed bundle:" + String.valueOf(element));
                                }
                                toRefresh.add(current);
                                break block25;
                            }
                            catch (BundleException e) {
                                if (Activator.DEBUG) {
                                    System.err.println("Can't install " + symbolicName + "/" + version + " from location " + String.valueOf(element.getLocation()));
                                    e.printStackTrace();
                                }
                                break block26;
                            }
                        }
                        if (this.inDevMode && current.getBundleId() != 0L && current != this.manipulatingContext.getBundle() && !bundleLocation.equals(current.getLocation()) && !current.getLocation().startsWith("initial@")) {
                            try {
                                current.uninstall();
                                toRefresh.add(current);
                            }
                            catch (BundleException e) {
                                if (Activator.DEBUG) {
                                    System.err.println("Can't uninstall " + symbolicName + "/" + version + " from location " + current.getLocation());
                                    e.printStackTrace();
                                }
                                break block26;
                            }
                            try {
                                current = this.manipulatingContext.installBundle(bundleLocation);
                                if (Activator.DEBUG) {
                                    System.out.println("installed bundle:" + String.valueOf(element));
                                }
                                toRefresh.add(current);
                            }
                            catch (BundleException e) {
                                if (Activator.DEBUG) {
                                    System.err.println("Can't install " + symbolicName + "/" + version + " from location " + String.valueOf(element.getLocation()));
                                    e.printStackTrace();
                                }
                                break block26;
                            }
                        }
                    }
                    if (element.isMarkedAsStarted()) {
                        toStart.add(current);
                    }
                    if ((startLevel = element.getStartLevel()) >= 1 && current.getBundleId() != 0L && !this.isFragment(current) && !"org.eclipse.equinox.simpleconfigurator".equals(current.getSymbolicName())) {
                        try {
                            ((BundleStartLevel)current.adapt(BundleStartLevel.class)).setStartLevel(startLevel);
                        }
                        catch (IllegalArgumentException ex) {
                            Utils.log(4, null, null, "Failed to set start level of Bundle:" + String.valueOf(element), ex);
                        }
                    }
                }
            }
            ++n2;
        }
        return toRefresh;
    }

    private boolean isFragment(Bundle current) {
        BundleRevision revision = (BundleRevision)current.adapt(BundleRevision.class);
        return revision != null && (revision.getTypes() & 1) != 0;
    }

    private void refreshPackages(Collection<Bundle> bundles) {
        if (bundles.isEmpty()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = event -> {
            if (event.getType() == 4) {
                latch.countDown();
            }
        };
        this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{listener});
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startBundles(Bundle[] bundles) {
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getState() == 1) {
                System.err.println("Could not start: " + bundle.getSymbolicName() + "(" + bundle.getLocation() + ":" + bundle.getBundleId() + "). It's state is uninstalled.");
            } else if ((bundle.getState() != 8 || bundle != this.callingBundle && bundle != this.manipulatingContext.getBundle()) && !this.isFragment(bundle) && bundle.getBundleId() != 0L) {
                try {
                    bundle.start();
                    if (Activator.DEBUG) {
                        System.out.println("started Bundle:" + bundle.getSymbolicName() + "(" + bundle.getLocation() + ":" + bundle.getBundleId() + ")");
                    }
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private Collection<Bundle> uninstallBundles(BundleInfo[] finalList) {
        Bundle[] allBundles = this.manipulatingContext.getBundles();
        HashSet<Bundle> removedBundles = new HashSet<Bundle>(allBundles.length);
        Object[] objectArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle allBundle = objectArray[n2];
            if (allBundle.getBundleId() != 0L) {
                removedBundles.add(allBundle);
            }
            ++n2;
        }
        objectArray = finalList;
        n = finalList.length;
        n2 = 0;
        while (n2 < n) {
            Bundle element = objectArray[n2];
            if (element != null) {
                Bundle[] toAdd = this.getBundles(element.getSymbolicName(), this.getVersionRange(element.getVersion()));
                int j = 0;
                while (toAdd != null && j < toAdd.length) {
                    removedBundles.remove(toAdd[j]);
                    ++j;
                }
            }
            ++n2;
        }
        Iterator iter = removedBundles.iterator();
        while (iter.hasNext()) {
            try {
                Bundle bundle = (Bundle)iter.next();
                if (bundle.getLocation().startsWith("initial@")) {
                    if (Activator.DEBUG) {
                        System.out.println("Simple configurator thinks a bundle installed by the boot strap should be uninstalled:" + bundle.getSymbolicName() + "(" + bundle.getLocation() + ":" + bundle.getBundleId() + ")");
                    }
                    iter.remove();
                    continue;
                }
                bundle.uninstall();
                if (!Activator.DEBUG) continue;
                System.out.println("uninstalled Bundle:" + bundle.getSymbolicName() + "(" + bundle.getLocation() + ":" + bundle.getBundleId() + ")");
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        return removedBundles;
    }

    private String getVersionRange(String version) {
        return version == null ? null : '[' + version + ',' + version + ']';
    }

    private Bundle[] getBundles(String symbolicName, String versionRange) {
        VersionRange range;
        String filter;
        Requirement identityReq;
        Collection identityCaps;
        if (symbolicName == null) {
            throw new IllegalArgumentException();
        }
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = this.systemBundle.getSymbolicName();
        }
        if ((identityCaps = this.frameworkWiring.findProviders(identityReq = ModuleContainer.createRequirement((String)"osgi.identity", Collections.singletonMap("filter", filter = ((range = versionRange == null ? null : new VersionRange(versionRange)) != null ? "(&" : "") + "(osgi.identity=" + symbolicName + ")" + (String)(range != null ? range.toFilterString("version") + ")" : "")), Collections.emptyMap()))).isEmpty()) {
            return null;
        }
        ArrayList<Bundle> sorted = new ArrayList<Bundle>(identityCaps.size());
        for (BundleCapability capability : identityCaps) {
            Bundle b = capability.getRevision().getBundle();
            if (!symbolicName.equals(b.getSymbolicName()) || sorted.contains(b)) continue;
            sorted.add(b);
        }
        Collections.sort(sorted, Comparator.comparing(Bundle::getVersion).reversed());
        if (sorted.isEmpty()) {
            return null;
        }
        return sorted.toArray(new Bundle[sorted.size()]);
    }
}

