/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenImages {
    private static final Logger log = LoggerFactory.getLogger(MavenImages.class);
    public static final ImageDescriptor M2 = MavenImages.createDescriptor("m2.svg");
    public static final ImageDescriptor DEBUG = MavenImages.createDescriptor("debug.svg");
    public static final ImageDescriptor ADD_INDEX = MavenImages.createDescriptor("add_index.svg");
    public static final ImageDescriptor NEW_POM = MavenImages.createDescriptor("new_m2_pom.svg");
    public static final ImageDescriptor REFRESH = MavenImages.createDescriptor("refresh.svg");
    public static final ImageDescriptor UPD_INDEX = MavenImages.createDescriptor("update_index.svg");
    public static final ImageDescriptor REBUILD_INDEX = MavenImages.createDescriptor("rebuild_index.svg");
    public static final ImageDescriptor POM = MavenImages.createDescriptor("pom_obj.svg");
    public static final ImageDescriptor SHOW_CONSOLE_ERR = MavenImages.createDescriptor("stderr.svg");
    public static final ImageDescriptor SHOW_CONSOLE_OUT = MavenImages.createDescriptor("stdout.svg");
    public static final ImageDescriptor MAVEN_OVERLAY = MavenImages.createDescriptor("mlabel.svg");
    public static final ImageDescriptor OUT_OF_DATE_OVERLAY = MavenImages.createDescriptor("dirty.svg");
    public static final ImageDescriptor EXPANDALL = MavenImages.createDescriptor("expandall.svg");
    public static final ImageDescriptor COLLAPSEALL = MavenImages.createDescriptor("collapseall.svg");
    public static final ImageDescriptor SUSPEND = MavenImages.createDescriptor("suspend.svg");
    public static final ImageDescriptor CLEAR = MavenImages.createDescriptor("clear.svg");
    public static final String PATH_JAR = "jar_obj.svg";
    public static final String PATH_PROJECT = "project_obj.svg";
    public static final String PATH_LOCK = "lock_ovr.svg";
    public static final String PATH_VERSION = "jar_version.svg";
    public static final String PATH_VERSION_SRC = "jar_src_version.svg";
    public static final Image IMG_JAR = MavenImages.createImage("jar_obj.svg");
    public static final Image IMG_VERSION = MavenImages.createImage("jar_version.svg");
    public static final Image IMG_VERSION_SRC = MavenImages.createImage("jar_src_version.svg");
    public static final Image IMG_LAUNCH_MAIN = MavenImages.createImage("main_tab.svg");
    public static final Image IMG_INDEX = MavenImages.createImage("maven_index.svg");
    public static final Image IMG_INDEXES = MavenImages.createImage("maven_indexes.svg");
    public static final Image IMG_PASSED = MavenImages.createImage("passed.svg");
    public static final Image IMG_INFO_AUTO = MavenImages.createImage("quick_fix_info_obj.svg");
    public static final Image IMG_POM = POM.createImage();
    public static final Image IMG_ERROR = MavenImages.createImage("error_st_obj.svg");
    public static final ImageDescriptor WIZ_IMPORT_WIZ = MavenImages.createDescriptor("import_project.svg");
    public static final ImageDescriptor WIZ_NEW_MAVEN_PROJECT = MavenImages.createDescriptor("banner_new_project.png");
    public static final ImageDescriptor WIZ_NEW_MODULE_PROJECT = MavenImages.createDescriptor("banner_new_module.png");
    public static final ImageDescriptor WIZ_UPDATE_PROJECT = MavenImages.createDescriptor("banner_update_project.png");
    public static final String MVN_PROJECT = "project-mlabel.gif";
    public static final String OOD_MVN_PROJECT = "out_of_date_project";

    private static ImageDescriptor createDescriptor(String key) {
        try {
            ImageRegistry imageRegistry = MavenImages.getImageRegistry();
            if (imageRegistry != null) {
                ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
                if (imageDescriptor == null) {
                    imageDescriptor = MavenImages.doCreateDescriptor(key);
                    imageRegistry.put(key, imageDescriptor);
                }
                return imageDescriptor;
            }
        }
        catch (Exception ex) {
            log.error(key, (Throwable)ex);
        }
        return null;
    }

    private static Image createImage(String key) {
        MavenImages.createDescriptor(key);
        ImageRegistry imageRegistry = MavenImages.getImageRegistry();
        return imageRegistry == null ? null : imageRegistry.get(key);
    }

    private static ImageRegistry getImageRegistry() {
        M2EUIPluginActivator plugin = M2EUIPluginActivator.getDefault();
        return plugin == null ? null : plugin.getImageRegistry();
    }

    private static ImageDescriptor doCreateDescriptor(String image) {
        return (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.m2e.core.ui", (String)("icons/" + image)).get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ImageDescriptor getOverlayImageDescriptor(String basekey, String overlaykey, int quadrant) {
        ImageDescriptor overlay;
        ImageDescriptor base;
        ImageDescriptor imageDescriptor;
        ImageRegistry imageRegistry;
        String key;
        block3: {
            key = basekey + overlaykey;
            imageRegistry = MavenImages.getImageRegistry();
            if (imageRegistry == null) return null;
            imageDescriptor = imageRegistry.getDescriptor(key);
            if (imageDescriptor != null) return imageDescriptor;
            base = MavenImages.createDescriptor(basekey);
            overlay = MavenImages.createDescriptor(overlaykey);
            if (base != null && overlay != null) break block3;
            log.error("cannot construct overlay image descriptor for " + basekey + " " + overlaykey);
            return null;
        }
        try {
            imageDescriptor = MavenImages.createOverlayDescriptor(base, overlay, quadrant);
            imageRegistry.put(key, imageDescriptor);
            return imageDescriptor;
        }
        catch (Exception ex) {
            log.error(key, (Throwable)ex);
        }
        return null;
    }

    public static Image getOverlayImage(String base, String overlay, int quadrant) {
        MavenImages.getOverlayImageDescriptor(base, overlay, quadrant);
        ImageRegistry imageRegistry = MavenImages.getImageRegistry();
        return imageRegistry == null ? null : imageRegistry.get(base + overlay);
    }

    public static Image createOverlayImage(String key, Image base, ImageDescriptor overlay, int quadrant) {
        ImageRegistry registry = MavenImages.getImageRegistry();
        if (registry != null) {
            Image image = registry.get(key);
            if (image == null) {
                ImageDescriptor descriptor = registry.getDescriptor(key);
                if (descriptor == null) {
                    registry.put(key, MavenImages.createOverlayDescriptor(base, overlay, quadrant));
                }
                image = registry.get(key);
            }
            return image;
        }
        return null;
    }

    private static ImageDescriptor createOverlayDescriptor(ImageDescriptor base, ImageDescriptor overlay, int quadrant) {
        return new DecorationOverlayIcon(base.createImage(), overlay, quadrant);
    }

    private static ImageDescriptor createOverlayDescriptor(Image base, ImageDescriptor overlay, int quadrant) {
        return new DecorationOverlayIcon(base, overlay, quadrant);
    }
}

