/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.html;

import org.apache.lucene.demo.html.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.lineSeparator();

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        int[][] nArray = this.expectedTokenSequences;
        int n = this.expectedTokenSequences.length;
        int n2 = 0;
        while (n2 < n) {
            int[] element = nArray[n2];
            if (maxSize < element.length) {
                maxSize = element.length;
            }
            int j = 0;
            while (j < element.length) {
                expected.append(this.tokenImage[element[j]]).append(" ");
                ++j;
            }
            if (element[element.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol).append("    ");
            ++n2;
        }
        Object retval = "Encountered \"";
        Token tok = this.currentToken.next;
        int i = 0;
        while (i < maxSize) {
            if (i != 0) {
                retval = (String)retval + " ";
            }
            if (tok.kind == 0) {
                retval = (String)retval + this.tokenImage[0];
                break;
            }
            retval = (String)retval + this.add_escapes(tok.image);
            tok = tok.next;
            ++i;
        }
        retval = (String)retval + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        retval = (String)retval + "." + this.eol;
        retval = this.expectedTokenSequences.length == 1 ? (String)retval + "Was expecting:" + this.eol + "    " : (String)retval + "Was expecting one of:" + this.eol + "    ";
        retval = (String)retval + expected.toString();
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

