/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.progress.UIJob;

public class QuickMenuHandler
extends AbstractHandler
implements IMenuListener2 {
    private QuickMenuCreator creator = new QuickMenuCreator(){

        @Override
        protected void fillMenu(IMenuManager menu) {
            if (!(menu instanceof ContributionManager)) {
                return;
            }
            IMenuService service = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
            service.populateContributionManager((ContributionManager)menu, QuickMenuHandler.this.locationURI);
            menu.addMenuListener((IMenuListener)QuickMenuHandler.this);
        }
    };
    private String locationURI;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.locationURI = event.getParameter("org.eclipse.ui.window.quickMenu.uri");
        if (this.locationURI == null) {
            throw new ExecutionException("locatorURI must not be null");
        }
        this.creator.createMenu();
        return null;
    }

    public void dispose() {
        if (this.creator != null) {
            this.creator.dispose();
            this.creator = null;
        }
    }

    public void menuAboutToHide(IMenuManager managerM) {
        UIJob.create("quickMenuCleanup", m -> {
            IMenuService service = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
            service.releaseContributions((ContributionManager)managerM);
        }).schedule();
    }

    public void menuAboutToShow(IMenuManager manager) {
    }
}

