/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.eclipse.jdt.apt.core.internal.declaration.DeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;

public abstract class MemberDeclarationImpl
extends DeclarationImpl
implements MemberDeclaration {
    MemberDeclarationImpl(IBinding binding, BaseProcessorEnv env) {
        super(binding, env);
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitMemberDeclaration(this);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        IAnnotationBinding[] instances = this.getAnnotationInstances();
        return this._getAnnotation(annotationClass, instances);
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        IAnnotationBinding[] instances = this.getAnnotationInstances();
        return this._getAnnotationMirrors(instances);
    }

    private IAnnotationBinding[] getAnnotationInstances() {
        IAnnotationBinding[] instances;
        IBinding binding = this.getDeclarationBinding();
        switch (binding.getKind()) {
            case 2: {
                instances = binding.getAnnotations();
                break;
            }
            case 4: {
                instances = binding.getAnnotations();
                break;
            }
            case 3: {
                instances = binding.getAnnotations();
                break;
            }
            case 1: {
                return null;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return instances;
    }

    @Override
    public String getDocComment() {
        ASTNode node;
        if (this.isFromSource() && (node = this.getAstNode()) != null) {
            ASTNode parent;
            if (node instanceof BodyDeclaration) {
                return this.getDocComment((BodyDeclaration)node);
            }
            if (node.getNodeType() == 59 && (parent = node.getParent()) instanceof BodyDeclaration) {
                return this.getDocComment((BodyDeclaration)parent);
            }
            return "";
        }
        return null;
    }

    @Override
    public SourcePosition getPosition() {
        if (this.isFromSource()) {
            ASTNode node = this.getRangeNode();
            if (node == null) {
                return null;
            }
            CompilationUnit unit = this.getCompilationUnit();
            int start = node.getStartPosition();
            return new SourcePositionImpl(start, node.getLength(), unit.getLineNumber(start), unit.getColumnNumber(start), this);
        }
        return null;
    }
}

