/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.util.Map;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.StandardBuildConfiguration;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MakeBuildSettingsTab
extends CommonBuildTab {
    private Button projectButton;
    private Button configButton;
    private Text buildCmdText;
    private Text cleanCmdText;
    private boolean defaultProject;

    protected String getBuildConfigProviderId() {
        return "org.eclipse.cdt.make.core.provider";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Control tcControl = this.createToolchainSelector(comp);
        tcControl.setLayoutData((Object)new GridData(4, 4, true, false));
        Group outputGroup = new Group(comp, 0);
        outputGroup.setText(Messages.MakeBuildSettingsTab_BuildOutputLocation);
        outputGroup.setLayout((Layout)new GridLayout());
        outputGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.projectButton = new Button((Composite)outputGroup, 16);
        this.projectButton.setText(Messages.MakeBuildSettingsTab_BuildInProjectDir);
        this.projectButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.configButton = new Button((Composite)outputGroup, 16);
        this.configButton.setText(Messages.MakeBuildSettingsTab_BuildInConfigDir);
        this.configButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group cmdGroup = new Group(comp, 0);
        cmdGroup.setText(Messages.MakeBuildSettingsTab_BuildCommands);
        cmdGroup.setLayout((Layout)new GridLayout(2, false));
        cmdGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label((Composite)cmdGroup, 0);
        label.setText(Messages.MakeBuildSettingsTab_Build);
        this.buildCmdText = new Text((Composite)cmdGroup, 2048);
        this.buildCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)cmdGroup, 0);
        label.setText(Messages.MakeBuildSettingsTab_Clean);
        this.cleanCmdText = new Text((Composite)cmdGroup, 2048);
        this.cleanCmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    public String getName() {
        return Messages.MakeBuildSettingsTab_Makefile;
    }

    protected void restoreProperties(Map<String, String> properties) {
        String cleanCommand;
        String buildCommand;
        super.restoreProperties(properties);
        String container = properties.get("stdbuild.build.container");
        if (container != null && !container.trim().isEmpty()) {
            Path containerLoc = new Path(container);
            if (containerLoc.segmentCount() == 1) {
                this.projectButton.setSelection(true);
                this.defaultProject = true;
            } else {
                this.configButton.setSelection(true);
                this.defaultProject = false;
            }
        }
        if ((buildCommand = properties.get("stdbuild.build.command")) != null && !buildCommand.trim().isEmpty()) {
            this.buildCmdText.setText(buildCommand);
        }
        if ((cleanCommand = properties.get("stdbuild.clean.command")) != null && !cleanCommand.trim().isEmpty()) {
            this.cleanCmdText.setText(cleanCommand);
        }
    }

    protected void saveProperties(Map<String, String> properties) {
        super.saveProperties(properties);
        try {
            ICBuildConfiguration buildConfig = this.getBuildConfiguration();
            if (buildConfig instanceof StandardBuildConfiguration) {
                String cleanCommand;
                StandardBuildConfiguration stdConfig = (StandardBuildConfiguration)buildConfig;
                if (this.defaultProject && !this.projectButton.getSelection()) {
                    properties.put("stdbuild.build.container", stdConfig.getDefaultBuildContainer().getFullPath().toString());
                } else if (!this.defaultProject && this.projectButton.getSelection()) {
                    properties.put("stdbuild.build.container", stdConfig.getProject().getFullPath().toString());
                }
                String buildCommand = this.buildCmdText.getText().trim();
                if (!buildCommand.isEmpty()) {
                    properties.put("stdbuild.build.command", buildCommand);
                }
                if (!(cleanCommand = this.cleanCmdText.getText().trim()).isEmpty()) {
                    properties.put("stdbuild.clean.command", cleanCommand);
                }
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.log(e.getStatus());
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String cleanCommand;
        String buildCommand;
        super.initializeFrom(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        if (buildConfig == null) {
            return;
        }
        String container = buildConfig.getProperty("stdbuild.build.container");
        if (container != null && !container.trim().isEmpty()) {
            Path containerLoc = new Path(container);
            if (containerLoc.segmentCount() == 1) {
                this.projectButton.setSelection(true);
                this.defaultProject = true;
            } else {
                this.configButton.setSelection(true);
                this.defaultProject = false;
            }
        }
        if ((buildCommand = buildConfig.getProperty("stdbuild.build.command")) != null && !buildCommand.trim().isEmpty()) {
            this.buildCmdText.setText(buildCommand);
        }
        if ((cleanCommand = buildConfig.getProperty("stdbuild.clean.command")) != null && !cleanCommand.trim().isEmpty()) {
            this.cleanCmdText.setText(cleanCommand);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        try {
            ICBuildConfiguration buildConfig = this.getBuildConfiguration();
            if (buildConfig instanceof StandardBuildConfiguration) {
                StandardBuildConfiguration stdConfig = (StandardBuildConfiguration)buildConfig;
                if (this.defaultProject && !this.projectButton.getSelection()) {
                    stdConfig.setBuildContainer(stdConfig.getDefaultBuildContainer());
                } else if (!this.defaultProject && this.projectButton.getSelection()) {
                    stdConfig.setBuildContainer((IContainer)stdConfig.getProject());
                }
                stdConfig.setBuildCommand(this.buildCmdText.getText());
                stdConfig.setCleanCommand(this.cleanCmdText.getText());
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.log(e.getStatus());
        }
    }
}

