/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.NestedResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.OneLineBorder;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListViewNodeListCompartmentItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.RegionCollapseAwarePropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.operation.ComparisonHelper;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;

public abstract class AbstractDNodeListCompartmentEditPart
extends ListCompartmentEditPart
implements INotableEditPart,
ISurfaceEditPart,
ISiriusEditPart {
    private boolean isSupportingViewActions = false;

    public AbstractDNodeListCompartmentEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListViewNodeListCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new RegionCollapseAwarePropertyHandlerEditPolicy());
    }

    public boolean isSupportingViewActions() {
        return this.isSupportingViewActions;
    }

    public void setIsSupportingViewActions(boolean supportsViewActions) {
        this.isSupportingViewActions = supportsViewActions;
    }

    protected boolean hasModelChildrenChanged(Notification evt) {
        return false;
    }

    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        boolean isRegion = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)this.resolveSemanticElement()).isRegion();
        if (isRegion) {
            NestedResizableCompartmentFigure nrcf = new NestedResizableCompartmentFigure(this.getMapMode());
            nrcf.getContentPane().setLayoutManager(result.getContentPane().getLayoutManager());
            Border border = result.getScrollPane().getContents().getBorder();
            if (border instanceof MarginBorder) {
                Insets insets = border.getInsets((IFigure)nrcf);
                border = new MarginBorder(0, insets.left, 0, insets.right);
                nrcf.getScrollPane().getContents().setBorder(border);
            }
            result = nrcf;
        }
        result.setTitleVisibility(false);
        result.setToolTip(null);
        this.configureBorder(result);
        IFigure contentPane = result.getContentPane();
        if (contentPane != null && contentPane.getBorder() instanceof MarginBorder) {
            Insets insets = contentPane.getBorder().getInsets((IFigure)result);
            Insets legacyBorderCompensation = new Insets(0, -1, isRegion ? 0 : -1, -1);
            contentPane.setBorder((Border)new MarginBorder(insets.getAdded(legacyBorderCompensation)));
        }
        return result;
    }

    private void configureBorder(ResizableCompartmentFigure rcf) {
        ViewQuery viewQuery = new ViewQuery((View)this.getModel());
        boolean isInShowingMode = viewQuery.isInShowingMode();
        if (this.hasLabelBorderStyle() || this.isLabelHidden() && !isInShowingMode || this.isCollapsed()) {
            if (rcf.getBorder() instanceof LineBorder || rcf.getBorder() == null) {
                rcf.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(1), 0, 0, 0));
            }
        } else if (rcf.getBorder() instanceof MarginBorder || rcf.getBorder() == null) {
            rcf.setBorder((Border)new OneLineBorder(this.getMapMode().DPtoLP(1), 8));
        }
    }

    private boolean isCollapsed() {
        DrawerStyle style = (DrawerStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        return style == null ? false : style.isCollapsed();
    }

    private boolean isLabelHidden() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElement) {
            return new DDiagramElementQuery((DDiagramElement)element).isLabelHidden();
        }
        return false;
    }

    private boolean hasLabelBorderStyle() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DDiagramElementContainer) {
            Optional labelBorderStyle = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)element).getLabelBorderStyle();
            return labelBorderStyle.isPresent() && !"labelBorderForContainer".equals(((LabelBorderStyleDescription)labelBorderStyle.get()).getId());
        }
        return false;
    }

    protected void refreshVisuals() {
        if (this.getFigure() instanceof ResizableCompartmentFigure) {
            ResizableCompartmentFigure rcf = (ResizableCompartmentFigure)this.getFigure();
            this.configureBorder(rcf);
        }
        super.refreshVisuals();
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent() != null && this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected List getModelChildren() {
        EObject semanticElement;
        List<View> modelChildren = ShowingViewUtil.getModelChildren(this.getModel());
        if (!modelChildren.isEmpty() && (semanticElement = this.resolveSemanticElement()) instanceof DNodeList) {
            new DNodeListElementComparisonHelper((DNodeList)semanticElement).sort(modelChildren);
        }
        return modelChildren;
    }

    protected void addNotationalListeners() {
        ViewQuery viewQuery;
        Optional<DDiagram> diagram;
        super.addNotationalListeners();
        if (this.hasNotationView() && (diagram = (viewQuery = new ViewQuery((View)this.getModel())).getDDiagram()).isPresent()) {
            this.addListenerFilter("ShowingMode", (NotificationListener)this, (EObject)diagram.get(), (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_IsInShowingMode());
        }
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("ShowingMode");
    }

    protected void setVisibility(boolean vis) {
        ShowingViewUtil.setVisibility((AbstractGraphicalEditPart)this, vis, 0, this.getFlag(8));
    }

    public boolean canAttachNote() {
        return true;
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public List getPrimaryEditParts() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        Object diagramEditPart = this.getViewer().getEditPartRegistry().get(this.getDiagramView());
        List shapes = this.getChildren();
        HashSet connectableEditParts = new HashSet(shapes);
        Iterator iter = shapes.iterator();
        while (iter.hasNext()) {
            this.getBorderItemEditParts((EditPart)iter.next(), connectableEditParts);
        }
        if (diagramEditPart instanceof DiagramEditPart) {
            for (ConnectionEditPart connection : ((DiagramEditPart)diagramEditPart).getConnections()) {
                if (!connectableEditParts.contains(connection.getSource()) && !connectableEditParts.contains(connection.getTarget())) continue;
                connections.add(connection);
            }
        }
        if (connections.size() > 0 || shapes.size() > 0) {
            ArrayList<ConnectionEditPart> primaryEditParts = new ArrayList<ConnectionEditPart>();
            primaryEditParts.addAll(shapes);
            primaryEditParts.addAll(connections);
            return primaryEditParts;
        }
        return Collections.EMPTY_LIST;
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        for (EditPart child : parent.getChildren()) {
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    public void refresh() {
        super.refresh();
        Iterable children = Iterables.filter((Iterable)this.getChildren(), EditPart.class);
        for (EditPart childEditPart : children) {
            childEditPart.refresh();
        }
    }

    public Command getCommand(Request _request) {
        RequestQuery requestQuery = new RequestQuery(_request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(_request);
    }

    protected void setCollapsed(boolean collapsed, boolean animate) {
        super.setCollapsed(collapsed, false);
    }

    private static class DNodeListElementComparisonHelper
    extends ComparisonHelper {
        private DNodeList self;

        public DNodeListElementComparisonHelper(DNodeList self) {
            this.self = self;
        }

        @Override
        protected List<? extends DRepresentationElement> getDElementsToSort() {
            return this.self.getOwnedElements();
        }

        @Override
        protected List<? extends RepresentationElementMapping> getMappingsToSort() {
            return MappingHelper.getAllNodeMappings((ContainerMapping)this.self.getActualMapping());
        }
    }
}

