/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.options;

import java.util.EnumSet;
import org.eclipse.elk.alg.radial.options.AnnulusWedgeCriteria;
import org.eclipse.elk.alg.radial.options.CompactionStrategy;
import org.eclipse.elk.alg.radial.options.RadialOptions;
import org.eclipse.elk.alg.radial.options.RadialTranslationStrategy;
import org.eclipse.elk.alg.radial.options.SortingStrategy;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RadialMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean CENTER_ON_ROOT_DEFAULT = false;
    public static final IProperty<Boolean> CENTER_ON_ROOT = new Property("org.eclipse.elk.radial.centerOnRoot", (Object)false, null, null);
    private static final int ORDER_ID_DEFAULT = 0;
    public static final IProperty<Integer> ORDER_ID = new Property("org.eclipse.elk.radial.orderId", (Object)0, null, null);
    private static final double RADIUS_DEFAULT = 0.0;
    public static final IProperty<Double> RADIUS = new Property("org.eclipse.elk.radial.radius", (Object)0.0, null, null);
    private static final boolean ROTATE_DEFAULT = false;
    public static final IProperty<Boolean> ROTATE = new Property("org.eclipse.elk.radial.rotate", (Object)false, null, null);
    private static final CompactionStrategy COMPACTOR_DEFAULT = CompactionStrategy.NONE;
    public static final IProperty<CompactionStrategy> COMPACTOR = new Property("org.eclipse.elk.radial.compactor", (Object)COMPACTOR_DEFAULT, null, null);
    private static final int COMPACTION_STEP_SIZE_DEFAULT = 1;
    private static final Comparable<? super Integer> COMPACTION_STEP_SIZE_LOWER_BOUND = 0;
    public static final IProperty<Integer> COMPACTION_STEP_SIZE = new Property("org.eclipse.elk.radial.compactionStepSize", (Object)1, COMPACTION_STEP_SIZE_LOWER_BOUND, null);
    private static final SortingStrategy SORTER_DEFAULT = SortingStrategy.NONE;
    public static final IProperty<SortingStrategy> SORTER = new Property("org.eclipse.elk.radial.sorter", (Object)SORTER_DEFAULT, null, null);
    private static final AnnulusWedgeCriteria WEDGE_CRITERIA_DEFAULT = AnnulusWedgeCriteria.NODE_SIZE;
    public static final IProperty<AnnulusWedgeCriteria> WEDGE_CRITERIA = new Property("org.eclipse.elk.radial.wedgeCriteria", (Object)WEDGE_CRITERIA_DEFAULT, null, null);
    private static final RadialTranslationStrategy OPTIMIZATION_CRITERIA_DEFAULT = RadialTranslationStrategy.NONE;
    public static final IProperty<RadialTranslationStrategy> OPTIMIZATION_CRITERIA = new Property("org.eclipse.elk.radial.optimizationCriteria", (Object)OPTIMIZATION_CRITERIA_DEFAULT, null, null);
    private static final double ROTATION_TARGET_ANGLE_DEFAULT = 0.0;
    public static final IProperty<Double> ROTATION_TARGET_ANGLE = new Property("org.eclipse.elk.radial.rotation.targetAngle", (Object)0.0, null, null);
    private static final boolean ROTATION_COMPUTE_ADDITIONAL_WEDGE_SPACE_DEFAULT = false;
    public static final IProperty<Boolean> ROTATION_COMPUTE_ADDITIONAL_WEDGE_SPACE = new Property("org.eclipse.elk.radial.rotation.computeAdditionalWedgeSpace", (Object)false, null, null);
    private static final boolean ROTATION_OUTGOING_EDGE_ANGLES_DEFAULT = false;
    public static final IProperty<Boolean> ROTATION_OUTGOING_EDGE_ANGLES = new Property("org.eclipse.elk.radial.rotation.outgoingEdgeAngles", (Object)false, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.centerOnRoot").group("").name("Center On Root").description("Centers the layout on the root of the tree i.e. so that the central node is also the center node of the final layout. This introduces additional whitespace.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.orderId").group("").name("Order ID").description("The id can be used to define an order for nodes of one radius. This can be used to sort them in the layer accordingly.").defaultValue((Object)0).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.NODES)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.radius").group("").name("Radius").description("The radius option can be used to set the initial radius for the radial layouter.").defaultValue((Object)0.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.rotate").group("").name("Rotate").description("The rotate option determines whether a rotation of the layout should be performed.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.compactor").group("").name("Compaction").description("With the compacter option it can be determined how compaction on the graph is done. It can be chosen between none, the radial compaction or the compaction of wedges separately.").defaultValue((Object)COMPACTOR_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(CompactionStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.compactionStepSize").group("").name("Compaction Step Size").description("Determine the size of steps with which the compaction is done. Step size 1 correlates to a compaction of 1 pixel per Iteration.").defaultValue((Object)1).lowerBound(COMPACTION_STEP_SIZE_LOWER_BOUND).type(LayoutOptionData.Type.INT).optionClass(Integer.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.addDependency("org.eclipse.elk.radial.compactionStepSize", "org.eclipse.elk.radial.compactor", null);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.sorter").group("").name("Sorter").description("Sort the nodes per radius according to the sorting algorithm. The strategies are none, by the given order id, or sorting them by polar coordinates.").defaultValue((Object)SORTER_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(SortingStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.wedgeCriteria").group("").name("Annulus Wedge Criteria").description("Determine how the wedge for the node placement is calculated. It can be chosen between wedge determination by the number of leaves or by the maximum sum of diagonals.").defaultValue((Object)WEDGE_CRITERIA_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(AnnulusWedgeCriteria.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.optimizationCriteria").group("").name("Translation Optimization").description("Find the optimal translation of the nodes of the first radii according to this criteria. For example edge crossings can be minimized.").defaultValue((Object)OPTIMIZATION_CRITERIA_DEFAULT).type(LayoutOptionData.Type.ENUM).optionClass(RadialTranslationStrategy.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.rotation.targetAngle").group("rotation").name("Target Angle").description("The angle in radians that the layout should be rotated to after layout.").defaultValue((Object)0.0).type(LayoutOptionData.Type.DOUBLE).optionClass(Double.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.VISIBLE).create());
        registry.addDependency("org.eclipse.elk.radial.rotation.targetAngle", "org.eclipse.elk.radial.rotate", null);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.rotation.computeAdditionalWedgeSpace").group("rotation").name("Additional Wedge Space").description("If set to true, modifies the target angle by rotating further such that space is left for an edge to pass in between the nodes. This option should only be used in conjunction with top-down layout.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        registry.addDependency("org.eclipse.elk.radial.rotation.computeAdditionalWedgeSpace", "org.eclipse.elk.radial.rotate", null);
        registry.register(new LayoutOptionData.Builder().id("org.eclipse.elk.radial.rotation.outgoingEdgeAngles").group("rotation").name("Outgoing Edge Angles").description("Calculate the required angle of connected nodes to leave space for an incoming edge. This option should only be used in conjunction with top-down layout.").defaultValue((Object)false).type(LayoutOptionData.Type.BOOLEAN).optionClass(Boolean.class).targets(EnumSet.of(LayoutOptionData.Target.PARENTS)).visibility(LayoutOptionData.Visibility.ADVANCED).create());
        new RadialOptions().apply(registry);
    }
}

