/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.handlers.NestableHandlerService;
import org.eclipse.ui.internal.handlers.SlaveHandlerService;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class HandlerServiceFactory
extends AbstractServiceFactory {
    @Override
    public Object create(Class serviceInterface, IServiceLocator parentLocator, IServiceLocator locator) {
        Expression parentExp;
        if (!IHandlerService.class.equals((Object)serviceInterface)) {
            return null;
        }
        IWorkbenchLocationService wls = locator.getService(IWorkbenchLocationService.class);
        IWorkbench wb = wls.getWorkbench();
        if (wb == null) {
            return null;
        }
        Object parent = parentLocator.getService(serviceInterface);
        if (parent == null) {
            ICommandService commands = locator.getService(ICommandService.class);
            IEvaluationService evals = locator.getService(IEvaluationService.class);
            HandlerService handlerService = new HandlerService(commands, evals, locator);
            handlerService.readRegistry();
            return handlerService;
        }
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        IWorkbenchPartSite site = wls.getPartSite();
        if (site == null) {
            WorkbenchWindowExpression exp = new WorkbenchWindowExpression(window);
            return new SlaveHandlerService((IHandlerService)parent, exp);
        }
        if (parent instanceof SlaveHandlerService && (parentExp = ((SlaveHandlerService)parent).getDefaultExpression()) instanceof ActivePartExpression) {
            return new NestableHandlerService((IHandlerService)parent, parentExp);
        }
        ActivePartExpression exp = new ActivePartExpression(site.getPart());
        return new SlaveHandlerService((IHandlerService)parent, exp);
    }
}

