/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.Arrays;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.addons.scanner.BarcodeScanner;
import org.eclipse.rap.rwt.addons.scanner.ScanListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class BarcodeScannerTab
extends ExampleTab {
    private BarcodeScanner scanner;
    private Text formatField;
    private Text dataField;
    private Text rawDataField;

    public BarcodeScannerTab() {
        super("BarcodeScanner");
        int[] nArray = new int[2];
        nArray[0] = 100;
        this.setHorizontalSashFormWeights(nArray);
    }

    @Override
    protected void createStyleControls(Composite parent) {
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, true));
        this.scanner = new BarcodeScanner(parent, 2048);
        GridData layoutData = new GridData(400, 300);
        layoutData.horizontalSpan = 2;
        this.scanner.setLayoutData((Object)layoutData);
        this.createResultGroup(parent);
        this.createStartScanButton(parent);
        this.createStopScanButton(parent);
        this.scanner.addScanListener(new ScanListener(){

            public void scanSucceeded(String format, String data, int[] rawData) {
                BarcodeScannerTab.this.formatField.setText(format);
                BarcodeScannerTab.this.dataField.setText(data);
                BarcodeScannerTab.this.rawDataField.setText(Arrays.toString(rawData));
            }

            public void scanFailed(String error) {
                BarcodeScannerTab.this.log("An error occurred while scanning the code: " + error);
            }
        });
        this.registerControl((Control)this.scanner);
    }

    private void createResultGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridData layoutData = new GridData(4, 4, false, false);
        layoutData.horizontalSpan = 2;
        group.setLayoutData((Object)layoutData);
        group.setText("Decoded data");
        group.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)group, 0).setText("Format");
        this.formatField = new Text((Composite)group, 2056);
        this.formatField.setLayoutData((Object)new GridData(4, -1, true, false));
        new Label((Composite)group, 0).setText("Data");
        this.dataField = new Text((Composite)group, 2056);
        this.dataField.setLayoutData((Object)new GridData(4, -1, true, false));
        new Label((Composite)group, 0).setText("Raw Data");
        this.rawDataField = new Text((Composite)group, 2056);
        this.rawDataField.setLayoutData((Object)new GridData(4, -1, true, false));
    }

    private void createStartScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, -1, false, false));
        button.setText("Start");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BarcodeScannerTab.this.scanner.start(new BarcodeScanner.Formats[]{BarcodeScanner.Formats.DATA_MATRIX, BarcodeScanner.Formats.QR_CODE});
            }
        });
    }

    private void createStopScanButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, -1, false, false));
        button.setText("Stop");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BarcodeScannerTab.this.scanner.stop();
                BarcodeScannerTab.this.formatField.setText("");
                BarcodeScannerTab.this.dataField.setText("");
                BarcodeScannerTab.this.rawDataField.setText("");
            }
        });
    }
}

