/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.TopologyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class TopologyManagerImpl
extends AbstractTopologyManager
implements EndpointListener,
EndpointEventListener {
    public static final int STARTUP_WAIT_TIME = Integer.getInteger("org.eclipse.ecf.osgi.services.remoteserviceadmin.startupWaitTime", 20000);
    private static final String ECF_DEFAULT_NAMESPACE = System.getProperty(String.valueOf(TopologyManagerImpl.class.getName()) + ".defaultNamespace", "org.eclipse.ecf.core.identity.StringID");
    private String ecfLocalEndpointListenerScope = System.getProperty(String.valueOf(TopologyManager.class.getName()) + ".ecfLocalEndpointListenerScope");
    private String ecfNonLocalEndpointListenerScope = System.getProperty(String.valueOf(TopologyManager.class.getName()) + ".ecfNonLocalEndpointListenerScope");
    private String nonECFLocalEndpointListenerScope = System.getProperty(String.valueOf(TopologyManager.class.getName()) + ".nonECFLocalEndpointListenerScope");
    private String nonECFNonLocalEndpointListenerScope = System.getProperty(String.valueOf(TopologyManager.class.getName()) + ".nonECFNonLocalEndpointListenerScope");
    private boolean nonECFTopologyManager = Boolean.valueOf(System.getProperty(String.valueOf(TopologyManagerImpl.class.getName()) + ".nonECFTopologyMananger", "false"));
    private boolean allowLocalHost;
    private List<String> otherFilters;

    private String processFrameworkLocal(String input) {
        return input.replaceAll("<<LOCAL>>", this.getFrameworkUUID());
    }

    boolean isNonECFTopologyManager() {
        return this.nonECFTopologyManager;
    }

    public TopologyManagerImpl(BundleContext context) {
        this(context, false, null);
    }

    public TopologyManagerImpl(BundleContext context, boolean allowLocalHost, String ... otherFilters) {
        super(context);
        this.allowLocalHost = this.nonECFTopologyManager ? true : allowLocalHost;
        String frameworkUUID = this.getFrameworkUUID();
        String localFrameworkFilter = new StringBuffer("(").append("endpoint.framework.uuid").append("=").append(frameworkUUID).append(")").toString();
        String nonLocalFrameworkFilter = new StringBuffer("(!" + localFrameworkFilter + ")").toString();
        this.ecfLocalEndpointListenerScope = this.ecfLocalEndpointListenerScope == null ? new StringBuffer("(&").append(localFrameworkFilter).append("(ecf.endpoint.id.ns=*)").append(")").toString() : this.processFrameworkLocal(this.ecfLocalEndpointListenerScope);
        this.ecfNonLocalEndpointListenerScope = this.ecfNonLocalEndpointListenerScope == null ? new StringBuffer("(&").append(nonLocalFrameworkFilter).append("(ecf.endpoint.id.ns=*)").append(")").toString() : this.processFrameworkLocal(this.ecfNonLocalEndpointListenerScope);
        String nonECFScope = "(!(ecf.endpoint.id.ns=*))";
        this.nonECFLocalEndpointListenerScope = this.nonECFLocalEndpointListenerScope == null ? new StringBuffer("(&").append(localFrameworkFilter).append(nonECFScope).append(")").toString() : this.processFrameworkLocal(this.nonECFLocalEndpointListenerScope);
        this.nonECFNonLocalEndpointListenerScope = this.nonECFNonLocalEndpointListenerScope == null ? new StringBuffer("(&").append(localFrameworkFilter).append(nonECFScope).append(")").toString() : this.processFrameworkLocal(this.nonECFNonLocalEndpointListenerScope);
        this.otherFilters = otherFilters == null ? new ArrayList() : Arrays.asList(otherFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getFrameworkUUID() {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String result = this.getContext().getProperty("org.osgi.framework.uuid");
            if (result == null) {
                UUID newUUID = UUID.randomUUID();
                result = newUUID.toString();
                System.setProperty("org.osgi.framework.uuid", newUUID.toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getScope() {
        TopologyManagerImpl topologyManagerImpl = this;
        synchronized (topologyManagerImpl) {
            ArrayList<String> l = new ArrayList<String>();
            if (this.allowLocalHost) {
                l.add(this.ecfLocalEndpointListenerScope);
            }
            l.add(this.ecfNonLocalEndpointListenerScope);
            if (this.nonECFTopologyManager) {
                if (this.allowLocalHost) {
                    l.add(this.nonECFLocalEndpointListenerScope);
                }
                l.add(this.nonECFNonLocalEndpointListenerScope);
            }
            if (this.otherFilters != null) {
                for (String s : this.otherFilters) {
                    l.add(s);
                }
            }
            return l.toArray(new String[l.size()]);
        }
    }

    @Override
    protected void handleEvent(ServiceEvent event, Map listeners) {
        if (!this.isNonECFTopologyManager()) {
            super.handleEvent(event, listeners);
        }
    }

    protected void handleRemoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        RemoteServiceAdmin.RemoteServiceAdminEvent rsaEvent = (RemoteServiceAdmin.RemoteServiceAdminEvent)event;
        int eventType = event.getType();
        EndpointDescription endpointDescription = rsaEvent.getEndpointDescription();
        switch (eventType) {
            case 2: {
                if (this.nonECFTopologyManager) break;
                this.advertiseEndpointDescription(endpointDescription);
                break;
            }
            case 3: {
                if (this.nonECFTopologyManager) break;
                this.unadvertiseEndpointDescription(endpointDescription);
                break;
            }
            case 6: {
                this.logError("handleRemoteAdminEvent.EXPORT_ERROR", "Export error with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 7: {
                this.logWarning("handleRemoteAdminEvent.EXPORT_WARNING", "Export warning with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 10: {
                if (this.nonECFTopologyManager) break;
                this.advertiseModifyEndpointDescription(endpointDescription);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.logError("handleRemoteAdminEvent.IMPORT_ERROR", "Import error with event=" + (Object)((Object)rsaEvent));
                break;
            }
            case 8: {
                this.logWarning("handleRemoteAdminEvent.IMPORT_WARNING", "Import warning with event=" + (Object)((Object)rsaEvent));
                break;
            }
            default: {
                this.logWarning("handleRemoteAdminEvent", "RemoteServiceAdminEvent=" + (Object)((Object)rsaEvent) + " received with unrecognized type");
            }
        }
    }

    public void endpointChanged(EndpointEvent event, String matchedFilter) {
        int eventType = event.getType();
        org.osgi.service.remoteserviceadmin.EndpointDescription ed = event.getEndpoint();
        switch (eventType) {
            case 1: {
                this.handleEndpointAdded(ed, matchedFilter);
                break;
            }
            case 2: {
                this.handleEndpointRemoved(ed, matchedFilter);
                break;
            }
            case 4: {
                this.handleEndpointModified(ed, matchedFilter);
                break;
            }
            case 8: {
                this.handleEndpointModifiedEndmatch(ed, matchedFilter);
            }
        }
    }

    protected void handleEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.nonECFLocalEndpointListenerScope)) {
            this.advertiseEndpointDescription(endpoint);
        } else if (matchedFilter.equals(this.nonECFNonLocalEndpointListenerScope)) {
            EndpointDescription ed = this.convertEndpointDescriptionFromOSGiToECF(endpoint);
            if (ed != null) {
                this.handleECFEndpointAdded(ed);
            }
        } else if (matchedFilter.equals(this.ecfNonLocalEndpointListenerScope) || matchedFilter.equals(this.ecfLocalEndpointListenerScope)) {
            this.handleECFEndpointAdded((EndpointDescription)endpoint);
        } else if (this.otherFilters.contains(matchedFilter)) {
            this.handleOtherFilterEndpointAdded(endpoint, matchedFilter);
        }
    }

    protected void handleOtherFilterEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected void handleEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.nonECFLocalEndpointListenerScope)) {
            this.unadvertiseEndpointDescription(endpoint);
        } else if (matchedFilter.equals(this.nonECFNonLocalEndpointListenerScope)) {
            EndpointDescription ed = this.convertEndpointDescriptionFromOSGiToECF(endpoint);
            if (ed != null) {
                this.handleECFEndpointRemoved(ed);
            }
        } else if (matchedFilter.equals(this.ecfNonLocalEndpointListenerScope) || matchedFilter.equals(this.ecfLocalEndpointListenerScope)) {
            this.handleECFEndpointRemoved((EndpointDescription)endpoint);
        } else if (this.otherFilters.contains(matchedFilter)) {
            this.handleOtherFilterEndpointRemoved(endpoint, matchedFilter);
        }
    }

    protected void handleOtherFilterEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected EndpointDescription convertEndpointDescriptionFromOSGiToECF(org.osgi.service.remoteserviceadmin.EndpointDescription ed) {
        HashMap<String, Object> newProps = new HashMap<String, Object>();
        newProps.putAll(ed.getProperties());
        String ecfNS = (String)newProps.remove("ecf.osgi.ns");
        if (ecfNS == null) {
            ecfNS = ECF_DEFAULT_NAMESPACE;
        }
        newProps.put("ecf.endpoint.id.ns", ecfNS);
        return new EndpointDescription(newProps);
    }

    protected void handleEndpointModifiedEndmatch(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected void handleOtherFilterEndpointModifiedEndmatch(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    private static Long getOSGiEndpointModifiedValue(Map<String, Object> properties) {
        Object modifiedValue = properties.get("ecf.osgi.endpoint.modified");
        if (modifiedValue != null && modifiedValue instanceof String) {
            return Long.valueOf((String)modifiedValue);
        }
        return null;
    }

    protected void handleEndpointModified(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.nonECFLocalEndpointListenerScope)) {
            Map edProperties = endpoint.getProperties();
            Long modified = TopologyManagerImpl.getOSGiEndpointModifiedValue(edProperties);
            HashMap<String, String> newEdProperties = new HashMap<String, String>();
            newEdProperties.putAll(endpoint.getProperties());
            if (modified != null) {
                newEdProperties.remove("ecf.osgi.endpoint.modified");
                this.handleNonECFEndpointModified(this, new org.osgi.service.remoteserviceadmin.EndpointDescription(newEdProperties));
            } else {
                newEdProperties.put("ecf.osgi.endpoint.modified", String.valueOf(System.currentTimeMillis()));
                this.advertiseModifyEndpointDescription(new org.osgi.service.remoteserviceadmin.EndpointDescription(newEdProperties));
            }
        } else if (matchedFilter.equals(this.nonECFNonLocalEndpointListenerScope)) {
            this.handleNonECFEndpointModified(this, endpoint);
        } else if (matchedFilter.equals(this.ecfNonLocalEndpointListenerScope) || matchedFilter.equals(this.ecfLocalEndpointListenerScope)) {
            this.handleECFEndpointModified((EndpointDescription)endpoint);
        } else if (this.otherFilters.contains(matchedFilter)) {
            this.handleOtherFilterEndpointModified(endpoint, matchedFilter);
        }
    }

    protected void handleOtherFilterEndpointModified(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected void exportRegisteredServices(final String exportRegisteredSvcsFilter) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final CountDownLatch latch = new CountDownLatch(1);
                    BundleTracker bt = new BundleTracker(TopologyManagerImpl.this.getContext(), 47, new BundleTrackerCustomizer(){

                        public Bundle addingBundle(Bundle bundle, BundleEvent event) {
                            String bsn = bundle.getSymbolicName();
                            if (bsn != null && bsn.equals("org.eclipse.ecf.osgi.services.remoteserviceadmin")) {
                                if (bundle.getState() == 32) {
                                    latch.countDown();
                                    return null;
                                }
                                return bundle;
                            }
                            return null;
                        }

                        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
                            if (event != null && event.getType() == 2) {
                                latch.countDown();
                            }
                        }

                        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
                        }
                    });
                    bt.open();
                    if (!latch.await(STARTUP_WAIT_TIME, TimeUnit.MILLISECONDS)) {
                        bt.close();
                        throw new TimeoutException("RemoteServiceAdmin did not become active in " + STARTUP_WAIT_TIME + "ms");
                    }
                    bt.close();
                    ServiceReference[] existingServiceRefs = TopologyManagerImpl.this.getContext().getAllServiceReferences(null, exportRegisteredSvcsFilter);
                    if (existingServiceRefs != null && existingServiceRefs.length > 0) {
                        int i = 0;
                        while (i < existingServiceRefs.length) {
                            TopologyManagerImpl.this.handleServiceRegistering(existingServiceRefs[i]);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    TopologyManagerImpl.this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
                }
            }
        }, "BasicTopologyManagerPreRegSrvExporter").start();
    }

    public void endpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointAdded(endpoint, matchedFilter);
    }

    public void endpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointRemoved(endpoint, matchedFilter);
    }
}

