/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceListener;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.URI;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisposeEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.provider.r_osgi.Activator;
import org.eclipse.ecf.internal.provider.r_osgi.LocalRemoteServiceReferenceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiContainerInstantiator;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteFilterImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceReferenceImpl;
import org.eclipse.ecf.internal.provider.r_osgi.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSSNamespace;
import org.eclipse.ecf.remoteservice.IOSGiRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRSAConsumerContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class R_OSGiRemoteServiceContainer
implements IOSGiRemoteServiceContainerAdapter,
IRemoteServiceContainerAdapter,
IContainer,
RemoteServiceListener,
IRSAConsumerContainerAdapter {
    private BundleContext context;
    private RemoteOSGiService remoteService;
    private final List containerListeners = new ArrayList(0);
    R_OSGiID containerID;
    private R_OSGiID connectedID;
    private ServiceTracker remoteServicesTracker;
    private Map remoteServicesRegs = new HashMap(0);
    private Map remoteServiceListeners = new HashMap(0);
    private IConnectContext connectContext;
    private boolean exposeRemoteServicesOnAllTransports = Boolean.parseBoolean(System.getProperty("org.eclipse.ecf.internal.provider.r_osgi.exposeRemoteServicesOnAllTransports", "false"));
    private Map refToImplMap = new HashMap();
    private Map cachedRemoteServiceReferences = new HashMap();

    public R_OSGiRemoteServiceContainer(RemoteOSGiService service, ID containerID) throws IDCreateException {
        Assert.isNotNull((Object)service);
        Assert.isNotNull((Object)containerID);
        this.context = Activator.getDefault().getContext();
        this.remoteService = service;
        if (containerID instanceof StringID) {
            this.containerID = this.createR_OSGiID(((StringID)containerID).getName());
        } else if (containerID instanceof R_OSGiID) {
            this.containerID = (R_OSGiID)containerID;
        } else {
            throw new IDCreateException("Incompatible ID " + containerID);
        }
        this.startRegTracker();
    }

    private void startRegTracker() {
        try {
            String filter = "(ecf.rsvc.cid=" + (Object)((Object)this.containerID) + ")";
            this.remoteServicesTracker = new ServiceTracker(this.context, this.context.createFilter(filter), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    return reference;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            });
            this.remoteServicesTracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void addRemoteServiceListener(final IRemoteServiceListener listener) {
        Assert.isNotNull((Object)listener);
        RemoteServiceListener l = new RemoteServiceListener(){

            public void remoteServiceEvent(final RemoteServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        listener.handleServiceEvent((IRemoteServiceEvent)new IRemoteServiceRegisteredEvent(){
                            IRemoteServiceReference reference;
                            {
                                this.reference = new RemoteServiceReferenceImpl(R_OSGiRemoteServiceContainer.this.createRemoteServiceID(remoteServiceEvent.getRemoteReference()), remoteServiceEvent.getRemoteReference());
                            }

                            public String[] getClazzes() {
                                return event.getRemoteReference().getServiceInterfaces();
                            }

                            public ID getContainerID() {
                                return this.getReference().getContainerID();
                            }

                            public IRemoteServiceReference getReference() {
                                return this.reference;
                            }

                            public String toString() {
                                return "RemoteServiceRegisteredEvent(" + (Object)((Object)(this).R_OSGiRemoteServiceContainer.this.containerID) + "," + this.getReference();
                            }

                            public ID getLocalContainerID() {
                                return R_OSGiRemoteServiceContainer.this.getID();
                            }
                        });
                        return;
                    }
                    case 4: {
                        listener.handleServiceEvent((IRemoteServiceEvent)new IRemoteServiceUnregisteredEvent(){
                            IRemoteServiceReference reference;
                            {
                                this.reference = new RemoteServiceReferenceImpl(R_OSGiRemoteServiceContainer.this.createRemoteServiceID(remoteServiceEvent.getRemoteReference()), remoteServiceEvent.getRemoteReference());
                            }

                            public String[] getClazzes() {
                                return event.getRemoteReference().getServiceInterfaces();
                            }

                            public ID getContainerID() {
                                return (this).R_OSGiRemoteServiceContainer.this.containerID;
                            }

                            public IRemoteServiceReference getReference() {
                                return this.reference;
                            }

                            public String toString() {
                                return "RemoteServiceUnregisteredEvent(" + (Object)((Object)(this).R_OSGiRemoteServiceContainer.this.containerID) + "," + this.getReference();
                            }

                            public ID getLocalContainerID() {
                                return R_OSGiRemoteServiceContainer.this.getID();
                            }
                        });
                        return;
                    }
                }
            }
        };
        ServiceRegistration reg = this.context.registerService(RemoteServiceListener.class.getName(), (Object)l, null);
        this.remoteServiceListeners.put(listener, reg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Assert.isNotNull((Object)reference);
        if (!(reference instanceof RemoteServiceReferenceImpl)) {
            return null;
        }
        RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
        Object rs = this.remoteService.getRemoteService(impl.getR_OSGiServiceReference());
        if (rs == null) {
            return null;
        }
        RemoteServiceImpl rsImpl = new RemoteServiceImpl(impl, rs);
        Map map = this.refToImplMap;
        synchronized (map) {
            ArrayList<RemoteServiceImpl> remoteServiceImplList = (ArrayList<RemoteServiceImpl>)this.refToImplMap.get(reference);
            if (remoteServiceImplList == null) {
                remoteServiceImplList = new ArrayList<RemoteServiceImpl>();
            }
            remoteServiceImplList.add(rsImpl);
            this.refToImplMap.put(reference, remoteServiceImplList);
        }
        return rsImpl;
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return this.getRemoteServiceReferences(target, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException {
        IRemoteFilter remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        List results = this.getRemoteServiceReferencesConnected(clazz, remoteFilter);
        if (results == null) {
            return null;
        }
        return results.toArray(new IRemoteServiceReference[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences(ID targetID, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        if (clazz == null) {
            return null;
        }
        IRemoteFilter remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        R_OSGiRemoteServiceContainer r_OSGiRemoteServiceContainer = this;
        synchronized (r_OSGiRemoteServiceContainer) {
            List results;
            block6: {
                results = new ArrayList();
                if (this.getConnectedID() == null) {
                    this.connect(targetID, this.connectContext);
                }
                if ((results = this.getRemoteServiceReferencesConnected(clazz, remoteFilter)) != null && results.size() != 0) break block6;
                return null;
            }
            return results.toArray(new IRemoteServiceReference[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getAllRemoteServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        RemoteServiceReference[] rrefs;
        IRemoteFilter remoteFilter;
        ArrayList<IRemoteServiceReference> results = new ArrayList<IRemoteServiceReference>();
        Map map = this.remoteServicesRegs;
        synchronized (map) {
            for (ServiceReference ref : this.remoteServicesRegs.keySet()) {
                Dictionary refProperties = this.prepareProperties(ref);
                if (clazz == null) {
                    results.add(this.createLocalRemoteServiceReference(ref));
                    continue;
                }
                IRemoteFilter rf = this.createRemoteFilter(filter != null ? "(&" + filter + "(" + "objectClass" + "=" + clazz + "))" : "(objectClass=" + clazz + ")");
                if (!rf.match(refProperties)) continue;
                results.add(this.createLocalRemoteServiceReference(ref));
            }
        }
        IRemoteFilter iRemoteFilter = remoteFilter = filter == null ? null : this.createRemoteFilter(filter);
        if (this.getConnectedID() != null && (rrefs = this.remoteService.getRemoteServiceReferences(this.connectedID.getURI(), clazz, (Filter)remoteFilter)) != null) {
            int i = 0;
            while (i < rrefs.length) {
                results.add(this.getCachedRemoteServiceReference(rrefs[i]));
                ++i;
            }
        }
        return results.toArray(new IRemoteServiceReference[0]);
    }

    private IRemoteServiceReference createLocalRemoteServiceReference(ServiceReference ref) {
        return new LocalRemoteServiceReferenceImpl(this.createRemoteServiceID(this.containerID, (Long)ref.getProperty("service.id")), ref);
    }

    private synchronized List getRemoteServiceReferencesConnected(String clazz, IRemoteFilter filter) {
        ArrayList<IRemoteServiceReference> results = new ArrayList<IRemoteServiceReference>();
        if (this.connectedID == null) {
            try {
                IRemoteServiceReference[] refs = this.getAllRemoteServiceReferences(clazz, filter == null ? null : filter.toString());
                if (refs == null) {
                    return results;
                }
                int i = 0;
                while (i < refs.length) {
                    results.add(refs[i]);
                    ++i;
                }
            }
            catch (InvalidSyntaxException refs) {}
        } else {
            RemoteServiceReference[] rrefs = this.remoteService.getRemoteServiceReferences(this.connectedID.getURI(), clazz, (Filter)filter);
            if (rrefs == null) {
                return results;
            }
            int i = 0;
            while (i < rrefs.length) {
                results.add(this.getCachedRemoteServiceReference(rrefs[i]));
                ++i;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteServiceReference getCachedRemoteServiceReference(RemoteServiceReference rref) {
        IRemoteServiceReference result = null;
        Map map = this.cachedRemoteServiceReferences;
        synchronized (map) {
            result = (IRemoteServiceReference)this.cachedRemoteServiceReferences.get(rref);
            if (result == null) {
                result = new RemoteServiceReferenceImpl(this.createRemoteServiceID(rref), rref);
                this.cachedRemoteServiceReferences.put(rref, result);
            }
        }
        return result;
    }

    IRemoteServiceID createRemoteServiceID(R_OSGiID cID, Long l) {
        return (IRemoteServiceID)IDFactory.getDefault().createID(this.getRemoteServiceNamespace(), new Object[]{cID, l});
    }

    IRemoteServiceID createRemoteServiceID(RemoteServiceReference rref) {
        URI uri = rref.getURI();
        String fragmentString = "#" + uri.getFragment();
        String uriStr = uri.toString();
        int fragmentLoc = uriStr.indexOf(fragmentString);
        if (fragmentLoc != -1) {
            uriStr = uriStr.substring(0, fragmentLoc);
        }
        return this.createRemoteServiceID(this.createR_OSGiID(uriStr), (Long)rref.getProperty("service.id"));
    }

    private R_OSGiID createR_OSGiID(String uriStr) {
        return R_OSGiContainerInstantiator.createR_OSGiID(this.getConnectNamespace(), uriStr);
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties) {
        return this.registerRemoteService(clazzes, service, properties, this.context);
    }

    public IRemoteServiceRegistration registerRemoteService(String[] clazzes, ServiceReference aServiceReference, Dictionary properties) {
        Object service = this.context.getService(aServiceReference);
        BundleContext bundleContext = aServiceReference.getBundle().getBundleContext();
        return this.registerRemoteService(clazzes, service, properties, bundleContext);
    }

    private String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    private Version getPackageVersion(Object service, String serviceInterface, String packageName) {
        ArrayList interfaces = new ArrayList();
        Class<?> serviceClass = service.getClass();
        while (!serviceClass.equals(Object.class)) {
            interfaces.addAll(Arrays.asList(serviceClass.getInterfaces()));
            serviceClass = serviceClass.getSuperclass();
        }
        Class[] interfaceClasses = interfaces.toArray(new Class[interfaces.size()]);
        if (interfaceClasses == null) {
            return null;
        }
        Class interfaceClass = null;
        int i = 0;
        while (i < interfaceClasses.length) {
            if (interfaceClasses[i].getName().equals(serviceInterface)) {
                interfaceClass = interfaceClasses[i];
            }
            ++i;
        }
        if (interfaceClass == null) {
            return null;
        }
        Bundle providingBundle = FrameworkUtil.getBundle(interfaceClass);
        if (providingBundle == null) {
            return null;
        }
        return this.getVersionForPackage(providingBundle, packageName);
    }

    private Version getVersionForMatchingCapability(String packageName, BundleCapability capability) {
        Map attributes = capability.getAttributes();
        String p = (String)attributes.get("osgi.wiring.package");
        if (p != null && packageName.equals(p)) {
            return (Version)attributes.get("version");
        }
        return null;
    }

    private Version getVersionForPackage(final Bundle providingBundle, String packageName) {
        Version result = null;
        BundleRevision providingBundleRevision = AccessController.doPrivileged(new PrivilegedAction<BundleRevision>(){

            @Override
            public BundleRevision run() {
                return (BundleRevision)providingBundle.adapt(BundleRevision.class);
            }
        });
        if (providingBundleRevision == null) {
            return null;
        }
        List providerCapabilities = providingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
        for (BundleCapability c : providerCapabilities) {
            result = this.getVersionForMatchingCapability(packageName, c);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteServiceRegistration registerRemoteService(String[] clazzes, Object service, Dictionary properties, BundleContext aContext) {
        if (this.containerID == null) {
            throw new IllegalStateException("Container is not connected");
        }
        Hashtable props = properties == null ? new Hashtable() : this.clone(properties);
        R_OSGiNamespace ns = (R_OSGiNamespace)this.containerID.getNamespace();
        Object rosgiRegistrationValue = Boolean.TRUE;
        if (!this.exposeRemoteServicesOnAllTransports) {
            rosgiRegistrationValue = ns instanceof R_OSGiWSSNamespace ? "https" : (ns instanceof R_OSGiWSNamespace ? "http" : "r-osgi");
        }
        ((Dictionary)props).put("service.remote.registration", rosgiRegistrationValue);
        ((Dictionary)props).remove("osgi.remote.interfaces");
        ((Dictionary)props).remove("service.exported.interfaces");
        ((Dictionary)props).put("ecf.rsvc.cid", this.containerID);
        ((Dictionary)props).put("ecf.robjectClass", clazzes);
        Integer serviceRanking = (Integer)((Dictionary)props).get("ecf.rsvc.ranking");
        serviceRanking = serviceRanking == null ? Integer.valueOf(0) : serviceRanking;
        ((Dictionary)props).put("ecf.rsvc.ranking", serviceRanking);
        String[] stringArray = clazzes;
        int n = clazzes.length;
        int n2 = 0;
        while (n2 < n) {
            String clazz = stringArray[n2];
            String packageName = this.getPackageName(clazz);
            String packageVersionKey = "endpoint.package.version." + packageName;
            Version packageVersion = this.getPackageVersion(service, clazz, packageName);
            if (packageVersion != null) {
                ((Dictionary)props).put(packageVersionKey, packageVersion.toString());
            }
            ++n2;
        }
        ServiceRegistration reg = aContext.registerService(clazzes, service, (Dictionary)props);
        reg.setProperties(this.prepareProperties(reg.getReference()));
        Map map = this.remoteServicesRegs;
        synchronized (map) {
            this.remoteServicesRegs.put(reg.getReference(), reg);
        }
        return new RemoteServiceRegistrationImpl(service.getClass().getClassLoader(), this, this.createRemoteServiceID(this.containerID, (Long)reg.getReference().getProperty("service.id")), reg);
    }

    Dictionary prepareProperties(ServiceReference reference) {
        String[] propKeys = reference.getPropertyKeys();
        Properties newDictionary = new Properties();
        int i = 0;
        while (i < propKeys.length) {
            Object v = reference.getProperty(propKeys[i]);
            ((Dictionary)newDictionary).put(propKeys[i], v);
            if ("service.id".equals(propKeys[i])) {
                ((Dictionary)newDictionary).put("ecf.rsvc.id", v);
            }
            ++i;
        }
        return newDictionary;
    }

    public void removeRemoteServiceListener(IRemoteServiceListener listener) {
        this.remoteServiceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetRemoteService(IRemoteServiceReference reference) {
        if (!(reference instanceof RemoteServiceReferenceImpl)) {
            return false;
        }
        RemoteServiceReferenceImpl impl = (RemoteServiceReferenceImpl)reference;
        RemoteServiceReference rsr = impl.getR_OSGiServiceReference();
        if (!rsr.isActive()) {
            return false;
        }
        this.remoteService.ungetRemoteService(rsr);
        Map map = this.refToImplMap;
        synchronized (map) {
            List remoteServiceImplList = (List)this.refToImplMap.remove(reference);
            if (remoteServiceImplList != null) {
                Iterator i = remoteServiceImplList.iterator();
                while (i.hasNext()) {
                    RemoteServiceImpl rsImpl = (RemoteServiceImpl)((Object)i.next());
                    if (rsImpl != null) {
                        rsImpl.dispose();
                    }
                    i.remove();
                }
            }
        }
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IRemoteServiceContainerAdapter.class)) {
            return this;
        }
        if (adapter.equals(IContainer.class)) {
            return this;
        }
        if (adapter.equals(IRSAConsumerContainerAdapter.class)) {
            return this;
        }
        return null;
    }

    public void addListener(IContainerListener listener) {
        this.containerListeners.add(listener);
    }

    public synchronized void connect(ID targetID, IConnectContext cc) throws ContainerConnectException {
        if (targetID == null) {
            throw new ContainerConnectException("targetID must not be null");
        }
        String targetNamespace = targetID.getNamespace().getName();
        if (!targetNamespace.equals(this.getConnectNamespace().getName()) && !targetNamespace.equals(StringID.class.getName())) {
            throw new ContainerConnectException("targetID is of incorrect connect namespace for this container");
        }
        if (this.connectedID != null) {
            if (this.connectedID.getName().equals(targetID.getName())) {
                return;
            }
            throw new ContainerConnectException("Container is already connected to " + (Object)((Object)this.connectedID));
        }
        this.connectContext = cc;
        try {
            R_OSGiID target = targetNamespace.equals(StringID.class.getName()) ? this.createR_OSGiID(((StringID)targetID).getName()) : (R_OSGiID)targetID;
            this.fireListeners((IContainerEvent)new ContainerConnectingEvent((ID)this.containerID, (ID)this.connectedID));
            RemoteServiceReference[] refs = this.doConnect(target);
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    this.checkImport(refs[i]);
                    ++i;
                }
            }
            this.connectedID = target;
            this.startRegTracker();
        }
        catch (IOException ioe) {
            throw new ContainerConnectException((Throwable)ioe);
        }
        catch (IDCreateException e) {
            throw new ContainerConnectException((Throwable)e);
        }
        this.fireListeners((IContainerEvent)new ContainerConnectedEvent((ID)this.containerID, (ID)this.connectedID));
    }

    private RemoteServiceReference[] doConnect(R_OSGiID targetID) throws IOException {
        return this.remoteService.connect(targetID.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect(R_OSGiID targetID) {
        Map map = this.cachedRemoteServiceReferences;
        synchronized (map) {
            this.cachedRemoteServiceReferences.clear();
        }
        this.remoteService.disconnect(targetID.getURI());
    }

    public synchronized void disconnect() {
        if (this.connectedID != null) {
            this.fireListeners((IContainerEvent)new ContainerDisconnectingEvent((ID)this.containerID, (ID)this.connectedID));
            this.doDisconnect(this.connectedID);
            this.connectedID = null;
            this.fireListeners((IContainerEvent)new ContainerDisconnectedEvent((ID)this.containerID, (ID)this.connectedID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        int i;
        if (this.remoteServicesTracker != null) {
            ServiceReference[] refs = this.remoteServicesTracker.getServiceReferences();
            if (refs != null) {
                i = 0;
                while (i < refs.length) {
                    ServiceRegistration reg = (ServiceRegistration)this.remoteServicesRegs.get(refs[i]);
                    if (reg != null) {
                        reg.unregister();
                    }
                    ++i;
                }
            }
            this.remoteServicesTracker.close();
            this.remoteServicesTracker = null;
        }
        ServiceRegistration[] lstn = this.remoteServiceListeners.values().toArray(new ServiceRegistration[this.remoteServiceListeners.size()]);
        i = 0;
        while (i < lstn.length) {
            try {
                lstn[i].unregister();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        if (this.connectedID != null) {
            this.disconnect();
        }
        Map map = this.refToImplMap;
        synchronized (map) {
            this.refToImplMap.clear();
        }
        this.fireListeners((IContainerEvent)new ContainerDisposeEvent((ID)this.containerID));
        this.containerListeners.clear();
    }

    public Namespace getConnectNamespace() {
        return R_OSGiNamespace.getDefault();
    }

    public synchronized ID getConnectedID() {
        return this.connectedID;
    }

    public void removeListener(IContainerListener listener) {
        this.containerListeners.remove(listener);
    }

    public ID getID() {
        return this.containerID;
    }

    private void fireListeners(final IContainerEvent event) {
        final IContainerListener[] listeners = this.containerListeners.toArray(new IContainerListener[this.containerListeners.size()]);
        new Thread(){

            @Override
            public void run() {
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].handleEvent(event);
                    ++i;
                }
            }
        }.start();
    }

    public void remoteServiceEvent(RemoteServiceEvent event) {
        if (event.getType() == 1) {
            this.checkImport(event.getRemoteReference());
        }
    }

    private void checkImport(RemoteServiceReference ref) {
        Object target = ref.getProperty("ecf.rsvc.reg.targets");
        if (target instanceof ID && ((ID)target).equals((Object)this.containerID)) {
            this.remoteService.getRemoteService(ref);
        } else if (target instanceof ID[]) {
            ID[] targets = (ID[])target;
            int i = 0;
            while (i < targets.length) {
                if (targets[i].equals((Object)this.containerID)) {
                    this.remoteService.getRemoteService(ref);
                }
                ++i;
            }
        }
    }

    private Hashtable clone(Dictionary props) {
        Hashtable clone = new Hashtable();
        Enumeration e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            clone.put(key, props.get(key));
        }
        return clone;
    }

    public IFuture asyncGetRemoteServiceReferences(final ID[] idFilter, final String clazz, final String filter) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return R_OSGiRemoteServiceContainer.this.getRemoteServiceReferences(idFilter, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final String clazz, final String filter) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return R_OSGiRemoteServiceContainer.this.getRemoteServiceReferences(target, clazz, filter);
            }
        }, null);
    }

    public IFuture asyncGetRemoteServiceReferences(final ID target, final ID[] idFilter, final String clazz, final String filter) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return R_OSGiRemoteServiceContainer.this.getRemoteServiceReferences(target, idFilter, clazz, filter);
            }
        }, null);
    }

    public Namespace getRemoteServiceNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.namespace.r_osgi.remoteservice");
    }

    public IRemoteFilter createRemoteFilter(String filter) throws InvalidSyntaxException {
        return new RemoteFilterImpl(this.context, filter);
    }

    public IRemoteServiceID getRemoteServiceID(ID containerId, long containerRelativeId) {
        return (IRemoteServiceID)IDFactory.getDefault().createID(this.getRemoteServiceNamespace(), new Object[]{this.containerID, new Long(containerRelativeId)});
    }

    public IRemoteServiceReference getRemoteServiceReference(IRemoteServiceID serviceId) {
        if (serviceId == null) {
            return null;
        }
        ID cID = serviceId.getContainerID();
        if (cID instanceof R_OSGiID && cID.equals((Object)this.getConnectedID())) {
            RemoteServiceReference[] refs;
            block5: {
                String filter = "(service.id=" + serviceId + ")";
                try {
                    refs = this.remoteService.getRemoteServiceReferences(((R_OSGiID)cID).getURI(), null, this.context.createFilter(filter));
                    if (refs != null && refs.length != 0) break block5;
                    return null;
                }
                catch (InvalidSyntaxException e) {
                    return null;
                }
            }
            return this.getCachedRemoteServiceReference(refs[0]);
        }
        return null;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRegistration(ServiceRegistration reg) {
        Map map = this.remoteServicesRegs;
        synchronized (map) {
            this.remoteServicesRegs.remove(reg.getReference());
        }
    }

    public IRemoteServiceReference[] importEndpoint(Map<String, Object> endpointDescriptionProperties) throws ContainerConnectException, InvalidSyntaxException {
        EndpointDescription endpointDescription = new EndpointDescription(endpointDescriptionProperties);
        ID endpointContainerID = endpointDescription.getContainerID();
        Assert.isNotNull((Object)endpointContainerID);
        ID tID = endpointDescription.getConnectTargetID();
        if (tID == null) {
            tID = endpointContainerID;
        }
        ID targetID = tID;
        return this.getRemoteServiceReferences(targetID, this.getIDFilter(endpointDescription, targetID), (String)endpointDescription.getInterfaces().iterator().next(), this.getRemoteServiceFilter(endpointDescription));
    }

    private String getRemoteServiceFilter(EndpointDescription endpointDescription) {
        String intf = (String)endpointDescription.getInterfaces().iterator().next();
        String packageName = intf.substring(0, intf.lastIndexOf(46));
        String edRsFilter = endpointDescription.getRemoteServiceFilter();
        if (edRsFilter == null) {
            Version intfPackageVersion = endpointDescription.getPackageVersion(packageName);
            edRsFilter = "(endpoint.package.version." + packageName + "=" + intfPackageVersion + ")";
        }
        long rsId = 0L;
        Long l = endpointDescription.getRemoteServiceId();
        if (l != null) {
            rsId = l;
        }
        if (rsId == 0L) {
            rsId = endpointDescription.getServiceId();
        }
        if (rsId == 0L) {
            return edRsFilter;
        }
        StringBuffer result = new StringBuffer("(&(").append("ecf.rsvc.id").append("=").append(rsId).append(")");
        if (edRsFilter != null) {
            result.append(edRsFilter);
        }
        result.append(")");
        return result.toString();
    }

    private ID[] getIDFilter(EndpointDescription endpointDescription, ID endpointID) {
        ID[] iDArray;
        ID[] idFilter = endpointDescription.getIDFilter();
        if (idFilter == null) {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = endpointID;
        } else {
            iDArray = idFilter;
        }
        return iDArray;
    }
}

