/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.SRVRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxResolver
implements DNSResolver {
    private static JavaxResolver instance;
    private static DirContext dirContext;

    static {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            dirContext = new InitialDirContext(env);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DNSUtil.setDNSResolver(JavaxResolver.getInstance());
    }

    private JavaxResolver() {
    }

    public static DNSResolver getInstance() {
        if (instance == null && JavaxResolver.isSupported()) {
            instance = new JavaxResolver();
        }
        return instance;
    }

    public static boolean isSupported() {
        return dirContext != null;
    }

    @Override
    public List<SRVRecord> lookupSRVRecords(String name) {
        ArrayList<SRVRecord> res = new ArrayList<SRVRecord>();
        try {
            Attributes dnsLookup = dirContext.getAttributes(name, new String[]{"SRV"});
            Attribute srvAttribute = dnsLookup.get("SRV");
            NamingEnumeration<?> srvRecords = srvAttribute.getAll();
            while (srvRecords.hasMore()) {
                SRVRecord srvRecord;
                String srvRecordString = (String)srvRecords.next();
                String[] srvRecordEntries = srvRecordString.split(" ");
                int priority = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 4]);
                int port = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
                int weight = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 3]);
                String host = srvRecordEntries[srvRecordEntries.length - 1];
                try {
                    srvRecord = new SRVRecord(host, port, priority, weight);
                }
                catch (Exception e) {
                    continue;
                }
                res.add(srvRecord);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

