/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.contentmodel.AttributeCollection;
import org.eclipse.wst.html.core.internal.contentmodel.CMContentImpl;
import org.eclipse.wst.html.core.internal.contentmodel.CMGroupImpl;
import org.eclipse.wst.html.core.internal.contentmodel.CMNamedNodeMapImpl;
import org.eclipse.wst.html.core.internal.contentmodel.ComplexTypeDefinition;
import org.eclipse.wst.html.core.internal.contentmodel.ComplexTypeDefinitionFactory;
import org.eclipse.wst.html.core.internal.contentmodel.ElementCollection;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLAttributeDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.PropertyProvider;
import org.eclipse.wst.html.core.internal.contentmodel.PropertyProviderFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

abstract class HTMLElemDeclImpl
extends CMContentImpl
implements HTMLElementDeclaration,
HTMLPropertyDeclaration {
    protected CMNamedNodeMapImpl attributes = null;
    protected String typeDefinitionName = "CTYPE_EMPTY";
    private ComplexTypeDefinition typeDefinition = null;
    protected CMGroupImpl inclusion = null;
    protected CMGroupImpl exclusion = null;
    protected CMNamedNodeMap prohibitedAncestors = null;
    protected int correctionType = 1000;
    protected int formatType = 10000;
    protected int layoutType = 100;
    protected int omitType = 0;
    protected boolean keepSpaces = false;
    protected boolean indentChild = false;
    protected ElementCollection elementCollection = null;
    protected AttributeCollection attributeCollection = null;
    private boolean is_obsolete = false;
    protected static final CMNamedNodeMap EMPTY_MAP = new CMNamedNodeMap(){

        public int getLength() {
            return 0;
        }

        public CMNode getNamedItem(String name) {
            return null;
        }

        public CMNode item(int index) {
            return null;
        }

        public Iterator iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
    };

    public HTMLElemDeclImpl(String elementName, ElementCollection collection) {
        super(elementName, 1, 1);
        this.elementCollection = collection;
        this.attributeCollection = collection.getAttributeCollection();
    }

    protected abstract void createAttributeDeclarations();

    private ComplexTypeDefinition createComplexTypeDefinition() {
        if (this.typeDefinitionName.equals("CTYPE_CDATA") || this.typeDefinitionName.equals("CTYPE_EMPTY") || this.typeDefinitionName.equals("CTYPE_PCDATA")) {
            return null;
        }
        ComplexTypeDefinitionFactory factory = ComplexTypeDefinitionFactory.getInstance();
        if (factory == null) {
            return null;
        }
        ComplexTypeDefinition def = factory.createTypeDefinition(this.typeDefinitionName, this.elementCollection);
        return def;
    }

    @Override
    public HTMLAttributeDeclaration getAttributeDeclaration(String attrName) {
        CMNode cmnode;
        if (this.attributes == null) {
            this.createAttributeDeclarations();
            if (this.attributes == null) {
                return null;
            }
        }
        if ((cmnode = this.attributes.getNamedItem(attrName)) == null) {
            return null;
        }
        return (HTMLAttributeDeclaration)cmnode;
    }

    public CMNamedNodeMap getAttributes() {
        if (this.attributes == null) {
            this.createAttributeDeclarations();
        }
        return this.attributes;
    }

    private ComplexTypeDefinition getComplexTypeDefinition() {
        if (this.typeDefinition == null) {
            this.typeDefinition = this.createComplexTypeDefinition();
        }
        return this.typeDefinition;
    }

    public CMContent getContent() {
        ComplexTypeDefinition def = this.getComplexTypeDefinition();
        return def != null ? def.getContent() : null;
    }

    public int getContentType() {
        ComplexTypeDefinition def = this.getComplexTypeDefinition();
        return def != null ? def.getContentType() : 5;
    }

    @Override
    public int getCorrectionType() {
        return this.correctionType;
    }

    public CMDataType getDataType() {
        return null;
    }

    public String getElementName() {
        return this.getNodeName();
    }

    @Override
    public CMContent getExclusion() {
        return null;
    }

    @Override
    public int getFormatType() {
        return this.formatType;
    }

    @Override
    public CMContent getInclusion() {
        return null;
    }

    @Override
    public int getLayoutType() {
        return this.layoutType;
    }

    @Override
    public int getLineBreakHint() {
        switch (this.getLayoutType()) {
            case 101: {
                return 12;
            }
            case 104: {
                return 11;
            }
            case 105: {
                return 12;
            }
        }
        return 10;
    }

    public CMNamedNodeMap getLocalElements() {
        return EMPTY_MAP;
    }

    public int getNodeType() {
        return 5;
    }

    @Override
    public int getOmitType() {
        return this.omitType;
    }

    @Override
    public CMNamedNodeMap getProhibitedAncestors() {
        return EMPTY_MAP;
    }

    @Override
    public boolean supports(String propertyName) {
        if (propertyName.equals("shouldIgnoreCase")) {
            return true;
        }
        if (propertyName.equals("contentHint")) {
            ComplexTypeDefinition def = this.getComplexTypeDefinition();
            return def != null;
        }
        if (propertyName.equals("isObsolete")) {
            return this.is_obsolete;
        }
        PropertyProvider pp = PropertyProviderFactory.getProvider(propertyName);
        if (pp == null) {
            return false;
        }
        return pp.supports(this);
    }

    @Override
    public Object getProperty(String propertyName) {
        if (propertyName.equals("shouldIgnoreCase")) {
            return new Boolean(true);
        }
        if (propertyName.equals("contentHint")) {
            ComplexTypeDefinition def = this.getComplexTypeDefinition();
            return def != null ? def.getPrimaryCandidate() : null;
        }
        if (propertyName.equals("isObsolete")) {
            return new Boolean(this.is_obsolete);
        }
        PropertyProvider pp = PropertyProviderFactory.getProvider(propertyName);
        if (pp == null) {
            return null;
        }
        return pp.get(this);
    }

    protected Iterator getTerminators() {
        return null;
    }

    @Override
    public boolean isJSP() {
        return false;
    }

    @Override
    public boolean shouldIndentChildSource() {
        return this.indentChild;
    }

    @Override
    public boolean shouldKeepSpaces() {
        return this.keepSpaces;
    }

    @Override
    public boolean shouldTerminateAt(HTMLElementDeclaration nextElement) {
        Iterator i = this.getTerminators();
        if (i == null) {
            return false;
        }
        String nextName = nextElement.getElementName();
        while (i.hasNext()) {
            if (!nextName.equals(i.next())) continue;
            return true;
        }
        return false;
    }

    public void obsolete(boolean is_obsolete) {
        this.is_obsolete = is_obsolete;
    }
}

