/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.tree.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.internal.gef.tree.dnd.TreeTransfer;

public class TreeDropListener
implements DropTargetListener {
    private final IEditPartViewer m_viewer;
    private DropTargetEvent m_currentEvent;
    private EditPart m_target;
    private ChangeBoundsRequest m_request;
    private Command m_command;
    private boolean m_isShowingFeedback;

    public TreeDropListener(IEditPartViewer viewer) {
        this.m_viewer = viewer;
        DropTarget target = new DropTarget(this.m_viewer.getControl(), 2);
        target.setTransfer(new Transfer[]{TreeTransfer.INSTANCE});
        target.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        this.m_currentEvent = event;
    }

    public void dropAccept(DropTargetEvent event) {
        this.m_currentEvent = event;
    }

    public void dragLeave(DropTargetEvent event) {
        this.m_currentEvent = event;
        this.clearState();
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.m_currentEvent = event;
        this.eraseTargetFeedback();
        this.updateTargetRequest();
        this.updateTargetEditPart();
        this.updateTargetRequestAfter();
        this.updateCommand();
    }

    public void dragOver(DropTargetEvent event) {
        boolean needUpdateFeedback = !this.m_isShowingFeedback || event.x != this.m_currentEvent.x || event.y != this.m_currentEvent.y;
        this.m_currentEvent = event;
        this.updateTargetRequest();
        this.updateTargetEditPart();
        this.updateTargetRequestAfter();
        this.updateCommand();
        if (needUpdateFeedback) {
            this.showTargetFeedback();
        }
        this.m_currentEvent.feedback = 0x18 | this.getTargetRequest().getDNDFeedback();
    }

    public void drop(DropTargetEvent event) {
        this.m_currentEvent = event;
        List<Object> models = this.getModels(this.getDragSource());
        this.eraseTargetFeedback();
        this.updateTargetRequest();
        this.updateTargetEditPart();
        this.updateTargetRequestAfter();
        try {
            this.executeCommand();
        }
        finally {
            this.clearState();
        }
        this.resetSelectionFromModels(models);
    }

    private void clearState() {
        this.eraseTargetFeedback();
        this.m_currentEvent = null;
        this.m_request = null;
        this.m_target = null;
    }

    private List<? extends EditPart> getDragSource() {
        return this.m_viewer.getSelectedEditParts();
    }

    private List<Object> getModels(List<? extends EditPart> editParts) {
        ArrayList<Object> models = new ArrayList<Object>();
        for (EditPart editPart : editParts) {
            models.add(editPart.getModel());
        }
        return models;
    }

    private void resetSelectionFromModels(List<Object> models) {
        if (!models.isEmpty()) {
            ArrayList<EditPart> newEditParts = new ArrayList<EditPart>();
            for (Object model : models) {
                EditPart newEditPart = (EditPart)this.m_viewer.getEditPartRegistry().get(model);
                newEditParts.add(newEditPart);
            }
            this.m_viewer.setSelection((ISelection)new StructuredSelection(newEditParts));
        }
    }

    private ChangeBoundsRequest getTargetRequest() {
        if (this.m_request == null) {
            this.m_request = new ChangeBoundsRequest("move");
            this.m_request.setEditParts(this.getDragSource());
        }
        return this.m_request;
    }

    private void updateTargetRequest() {
        ChangeBoundsRequest request = this.getTargetRequest();
        request.setLocation(this.getDropLocation());
    }

    private void updateTargetRequestAfter() {
        ChangeBoundsRequest request = this.getTargetRequest();
        if (this.getDragSource().get(0).getParent() == this.m_target) {
            request.setType("move");
        } else {
            request.setType("add children");
        }
    }

    private void setTargetEditPart(EditPart target) {
        if (this.m_target != target) {
            if (this.m_target != null) {
                this.eraseTargetFeedback();
            }
            this.m_target = target;
        }
    }

    private void updateTargetEditPart() {
        Point location = this.getDropLocation();
        Set<? extends EditPart> editParts = TreeDropListener.includeChildren(this.getDragSource());
        EditPart editPart = this.m_viewer.findObjectAtExcluding(location, Collections.emptyList(), this.getTargetingConditional(editParts));
        if (editPart != null) {
            editPart = editPart.getTargetEditPart((Request)this.getTargetRequest());
        }
        this.setTargetEditPart(editPart);
    }

    private Point getDropLocation() {
        DropTarget target = (DropTarget)this.m_currentEvent.widget;
        org.eclipse.swt.graphics.Point location = target.getControl().toControl(this.m_currentEvent.x, this.m_currentEvent.y);
        return new Point(location);
    }

    private EditPartViewer.Conditional getTargetingConditional(Collection<? extends EditPart> exclude) {
        return editPart -> !exclude.contains(editPart) && editPart.getTargetEditPart((Request)this.getTargetRequest()) != null;
    }

    private static Set<? extends EditPart> includeChildren(List<? extends EditPart> parts) {
        HashSet<Object> result = new HashSet<Object>();
        for (EditPart editPart : parts) {
            result.add(editPart);
            result.addAll(TreeDropListener.includeChildren(editPart.getChildren()));
        }
        return result;
    }

    private void executeCommand() {
        if (this.m_command != null) {
            try {
                this.m_viewer.getEditDomain().getCommandStack().execute(this.m_command);
            }
            finally {
                this.setCommand(null);
            }
        }
    }

    private void setCommand(Command command) {
        this.m_command = command;
        this.m_currentEvent.detail = this.m_command == null ? 0 : 2;
    }

    private void updateCommand() {
        this.setCommand(this.getCommand());
    }

    private Command getCommand() {
        if (this.m_target != null) {
            return this.m_target.getCommand((Request)this.getTargetRequest());
        }
        return null;
    }

    private void showTargetFeedback() {
        if (this.m_target != null) {
            this.m_target.showTargetFeedback((Request)this.getTargetRequest());
        }
        this.m_isShowingFeedback = true;
    }

    private void eraseTargetFeedback() {
        if (this.m_isShowingFeedback) {
            this.m_isShowingFeedback = false;
            if (this.m_target != null) {
                this.m_target.eraseTargetFeedback((Request)this.getTargetRequest());
            }
        }
    }
}

