/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.contentassist;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.ComboContentAssistSubjectAdapter;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.contentassist.TextContentAssistSubjectAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contentassist.ContentAssistMessages;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.keys.IBindingService;

@Deprecated
public class ContentAssistHandler {
    private final Control fControl;
    private final AbstractControlContentAssistSubjectAdapter fContentAssistSubjectAdapter;
    private final SubjectControlContentAssistant fContentAssistant;
    private FocusListener fFocusListener;
    private IHandlerActivation fHandlerActivation;

    public static ContentAssistHandler createHandlerForCombo(Combo combo, SubjectControlContentAssistant contentAssistant) {
        return new ContentAssistHandler((Control)combo, (AbstractControlContentAssistSubjectAdapter)new ComboContentAssistSubjectAdapter(combo), contentAssistant);
    }

    public static ContentAssistHandler createHandlerForText(Text text, SubjectControlContentAssistant contentAssistant) {
        return new ContentAssistHandler((Control)text, (AbstractControlContentAssistSubjectAdapter)new TextContentAssistSubjectAdapter(text), contentAssistant);
    }

    private ContentAssistHandler(Control control, AbstractControlContentAssistSubjectAdapter subjectAdapter, SubjectControlContentAssistant contentAssistant) {
        this.fControl = control;
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectAdapter = subjectAdapter;
        this.setEnabled(true);
        this.fControl.addDisposeListener(e -> this.setEnabled(false));
    }

    public boolean isEnabled() {
        return this.fFocusListener != null;
    }

    public void setEnabled(boolean enable) {
        if (enable == this.isEnabled()) {
            return;
        }
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private void enable() {
        if (!this.fControl.isDisposed()) {
            this.fContentAssistant.install((IContentAssistSubjectControl)this.fContentAssistSubjectAdapter);
            this.installCueLabelProvider();
            this.installFocusListener();
            if (this.fControl.isFocusControl()) {
                this.activateHandler();
            }
        }
    }

    private void disable() {
        if (!this.fControl.isDisposed()) {
            this.fContentAssistant.uninstall();
            this.fContentAssistSubjectAdapter.setContentAssistCueProvider(null);
            this.fControl.removeFocusListener(this.fFocusListener);
            this.fFocusListener = null;
            if (this.fHandlerActivation != null) {
                this.deactivateHandler();
            }
        }
    }

    private void installCueLabelProvider() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
                TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
                if (activeBindings.length == 0) {
                    return ContentAssistMessages.ContentAssistHandler_contentAssistAvailable;
                }
                return NLSUtility.format(ContentAssistMessages.ContentAssistHandler_contentAssistAvailableWithKeyBinding, activeBindings[0].format());
            }
        };
        this.fContentAssistSubjectAdapter.setContentAssistCueProvider((ILabelProvider)labelProvider);
    }

    private void installFocusListener() {
        this.fFocusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ContentAssistHandler.this.fHandlerActivation == null) {
                    ContentAssistHandler.this.activateHandler();
                }
            }

            public void focusLost(FocusEvent e) {
                if (ContentAssistHandler.this.fHandlerActivation != null) {
                    ContentAssistHandler.this.deactivateHandler();
                }
            }
        };
        this.fControl.addFocusListener(this.fFocusListener);
    }

    private void activateHandler() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (handlerService == null) {
            return;
        }
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (ContentAssistHandler.this.isEnabled()) {
                    ContentAssistHandler.this.fContentAssistant.showPossibleCompletions();
                }
                return null;
            }
        };
        this.fHandlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)handler);
    }

    private void deactivateHandler() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (handlerService != null) {
            handlerService.deactivateHandler(this.fHandlerActivation);
        }
        this.fHandlerActivation = null;
    }
}

