/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IStackTrace;

public class StackTraceProxy
implements IStackTrace {
    private final IChannel channel;

    public StackTraceProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public IToken getChildren(String parent_context_id, final IStackTrace.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = StackTraceProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken getChildrenRange(String parent_context_id, int range_start, int range_end, final IStackTrace.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildrenRange", (Object[])new Object[]{parent_context_id, Integer.valueOf((int)range_start), Integer.valueOf((int)range_end)}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = StackTraceProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken getContext(String[] id, final IStackTrace.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                IStackTrace.StackTraceContext[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[1]);
                    arr = StackTraceProxy.this.toContextArray(args[0]);
                }
                done.doneGetContext(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public String getName() {
        return "StackTrace";
    }

    private IStackTrace.StackTraceContext[] toContextArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int n = 0;
        IStackTrace.StackTraceContext[] ctx = new IStackTrace.StackTraceContext[c.size()];
        for (Map m : c) {
            IStackTrace.StackTraceContext stackTraceContext = ctx[n++] = m != null ? new Context(m) : null;
        }
        return ctx;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private class Context
    implements IStackTrace.StackTraceContext {
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public Number getArgumentsAddress() {
            return (Number)this.props.get("ArgsAddr");
        }

        @Override
        public int getArgumentsCount() {
            Number n = (Number)this.props.get("ArgsCnt");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Number getFrameAddress() {
            return (Number)this.props.get("FP");
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public Number getReturnAddress() {
            return (Number)this.props.get("RP");
        }

        @Override
        public Number getInstructionAddress() {
            return (Number)this.props.get("IP");
        }

        @Override
        public ILineNumbers.CodeArea getCodeArea() {
            Map area = (Map)this.props.get("CodeArea");
            if (area == null) {
                return null;
            }
            return new ILineNumbers.CodeArea(area, null);
        }

        @Override
        public String getFuncID() {
            return (String)this.props.get("FuncID");
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }
    }
}

