/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import java_cup.runtime.lr_parser;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.php.core.compiler.ast.nodes.ASTError;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.IRecoverable;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.compiler.ast.parser.Messages;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;

public abstract class AbstractASTParser
extends lr_parser {
    private PHPModuleDeclaration program = new PHPModuleDeclaration(0, 0, new LinkedList<ASTNode>(), new LinkedList<ASTError>(), new LinkedList<VarComment>());
    private IProblemReporter problemReporter;
    private String fileName;
    public Statement pendingStatement = null;
    public NamespaceDeclaration currentNamespace = null;
    public boolean metUnbracketedNSDecl;
    public boolean metBracketedNSDecl;
    public Stack<Statement> declarations = new Stack();

    public AbstractASTParser() {
    }

    public AbstractASTParser(Scanner s) {
        super(s);
    }

    public AbstractASTParser(Scanner s, SymbolFactory sf) {
        super(s, sf);
    }

    public void setProblemReporter(IProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public IProblemReporter getProblemReporter() {
        return this.problemReporter;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected List<ASTError> getErrors() {
        return this.program.getErrors();
    }

    protected void reportError(IProblemReporter problemReporter, String fileName, int start, int end, int lineNumber, IProblemIdentifier problemIdentifier, String message) {
        DefaultProblem problem = new DefaultProblem(fileName, message, problemIdentifier, new String[0], ProblemSeverities.Error, start, end, lineNumber, -1);
        problemReporter.reportProblem((IProblem)problem);
    }

    public void reportError() {
        this.program.setHasErrors(true);
    }

    public void reportError(ASTError error) {
        this.reportError(error, null);
    }

    public void reportError(ASTError error, String message) {
        this.getErrors().add(error);
        this.reportError();
        if (message != null && this.problemReporter != null && this.fileName != null) {
            int lineNumber = ((AstLexer)this.getScanner()).getCurrentLine();
            this.reportError(this.problemReporter, this.fileName, error.sourceStart(), error.sourceEnd(), lineNumber, error.getProblem(), message);
        }
    }

    public void addStatement(Statement s) {
        int kind = s.getKind();
        if (kind != 22 && kind != 19 && kind != 69 && this.metBracketedNSDecl) {
            this.reportError(new ASTError(s.sourceStart(), s.sourceEnd()), Messages.AbstractASTParser_0);
        }
        if (this.currentNamespace != null && this.currentNamespace != s) {
            this.currentNamespace.addStatement(s);
        } else {
            this.program.addStatement(s);
        }
    }

    public PHPModuleDeclaration getModuleDeclaration() {
        return this.program;
    }

    public void report_error(String message, Object info) {
        if (info instanceof Symbol) {
            if (((Symbol)info).left != -1) {
                ASTError error = new ASTError(((Symbol)info).left, ((Symbol)info).right);
                this.reportError(error);
            } else {
                this.reportError(new ASTError(0, 1));
            }
        }
    }

    public void unrecovered_syntax_error(Symbol cur_token) throws Exception {
        IRecoverable recoverable;
        ASTNode lastStatement;
        List<ASTError> errors;
        int start = 0;
        int end = 0;
        Object value = cur_token.value;
        PHPModuleDeclaration program = this.getModuleDeclaration();
        List statements = program.getStatements();
        if (value instanceof List) {
            statements.addAll((List)value);
        }
        if (!this.declarations.isEmpty()) {
            statements.add((ASTNode)this.declarations.remove(0));
        }
        if (!statements.isEmpty()) {
            Statement s1 = (Statement)statements.get(0);
            Statement s2 = (Statement)statements.get(statements.size() - 1);
            start = s1.sourceStart();
            end = s2.sourceEnd();
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            ASTError lastError = errors.get(errors.size() - 1);
            end = end > lastError.sourceEnd() ? end : lastError.sourceEnd();
        }
        program.setStart(start);
        program.setEnd(end);
        if (statements.size() > 0 && (lastStatement = (ASTNode)statements.get(statements.size() - 1)) instanceof IRecoverable && (recoverable = (IRecoverable)lastStatement).isRecovered()) {
            lastStatement.setEnd(end);
        }
        super.unrecovered_syntax_error(cur_token);
    }

    public void syntax_error(Symbol cur_token) {
        String currentText;
        super.syntax_error(cur_token);
        if (this.fileName == null || this.problemReporter == null) {
            return;
        }
        int state = ((Symbol)this.stack.peek()).parse_state;
        short[] rowOfProbe = this.action_tab[state];
        int startPosition = cur_token.left;
        int endPosition = cur_token.right;
        int lineNumber = ((AstLexer)this.getScanner()).getCurrentLine();
        StringBuilder errorMessage = new StringBuilder(Messages.AbstractASTParser_1);
        String string = currentText = cur_token.value instanceof String ? (String)cur_token.value : null;
        if (currentText == null || currentText.length() == 0) {
            currentText = this.getTokenName(cur_token.sym);
        }
        if (currentText != null && currentText.length() > 0) {
            if (currentText.equals(";")) {
                currentText = "EOF";
            }
            endPosition = startPosition + currentText.length();
            errorMessage.append(Messages.AbstractASTParser_4).append(currentText).append('\'');
        }
        if (rowOfProbe.length <= 6) {
            errorMessage.append(Messages.AbstractASTParser_5);
            boolean first = true;
            int probe = 0;
            while (probe < rowOfProbe.length) {
                String tokenName = this.getTokenName(rowOfProbe[probe]);
                if (tokenName != null) {
                    if (!first) {
                        errorMessage.append(Messages.AbstractASTParser_6);
                    }
                    errorMessage.append('\'').append(tokenName).append('\'');
                    first = false;
                }
                probe += 2;
            }
        }
        this.reportError(this.problemReporter, this.fileName, startPosition, endPosition, lineNumber, PHPProblemIdentifier.SYNTAX, errorMessage.toString());
    }

    protected abstract String getTokenName(int var1);

    public void report_fatal_error(String message, Object info) throws Exception {
        this.done_parsing();
    }

    public void addDeclarationStatement(Statement s) {
        if (this.declarations.isEmpty()) {
            if (s.getKind() == 69 && this.program.getStatements().size() > 0 && !this.metBracketedNSDecl && !this.metUnbracketedNSDecl) {
                boolean justDeclarationNodes = true;
                for (Object statement : this.program.getStatements()) {
                    if (((Statement)statement).getKind() == 19) continue;
                    justDeclarationNodes = false;
                    break;
                }
                if (!justDeclarationNodes) {
                    this.reportError(new ASTError(s.sourceStart(), s.sourceEnd()), Messages.AbstractASTParser_7);
                }
            }
            return;
        }
        Statement node = this.declarations.peek();
        Block block = null;
        if (node instanceof TypeDeclaration) {
            block = ((TypeDeclaration)node).getBody();
        } else if (node instanceof MethodDeclaration) {
            block = ((MethodDeclaration)node).getBody();
        } else if (node instanceof Block) {
            block = (Block)node;
        } else if (node instanceof AnonymousClassDeclaration) {
            block = ((AnonymousClassDeclaration)node).getBody();
        }
        if (block == null) {
            return;
        }
        block.addStatement((ASTNode)s);
        block.setEnd(s.sourceEnd());
    }

    public ASTNode getRecentDeclarationStatement() {
        Statement node = this.declarations.peek();
        Block block = null;
        if (node instanceof TypeDeclaration) {
            block = ((TypeDeclaration)node).getBody();
        } else if (node instanceof MethodDeclaration) {
            block = ((MethodDeclaration)node).getBody();
        } else if (node instanceof Block) {
            block = (Block)node;
        } else if (node instanceof AnonymousClassDeclaration) {
            block = ((AnonymousClassDeclaration)node).getBody();
        }
        if (block == null || block.getStatements().size() == 0) {
            return node;
        }
        return (ASTNode)block.getStatements().get(block.getStatements().size() - 1);
    }

    protected int appendModifier(int start, int end, int flags, int newFlag) {
        if ((flags & 0x70) != 0 && (newFlag & 0x70) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleAccessModifiersError);
        }
        if ((flags & 0x80) != 0 && (newFlag & 0x80) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleStaticModifiersError);
        }
        return flags | newFlag;
    }

    protected int appendMethodModifier(int start, int end, int flags, int newFlag) {
        if ((flags & 1) != 0 && (newFlag & 1) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleAbstractModifierError);
        }
        if ((flags & 4) != 0 && (newFlag & 4) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleFinalModifierError);
        }
        if (((flags = this.appendModifier(start, end, flags, newFlag)) & 1) != 0 && (flags & 4) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_AbstractAsFinalError);
        }
        return flags;
    }

    protected int appendPropertyModifier(int start, int end, int flags, int newFlag) {
        flags = this.appendModifier(start, end, flags, newFlag);
        if ((newFlag & 1) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_AbstractPropertyError);
        }
        if ((newFlag & 4) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_FinalPropertyError);
        }
        return flags;
    }

    protected int appendClassModifier(int start, int end, int flags, int newFlag) {
        if ((flags & 1) != 0 && (newFlag & 1) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleAbstractModifierError);
        }
        if ((flags & 4) != 0 && (newFlag & 4) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_MultipleFinalModifierError);
        }
        if (((flags = this.appendModifier(start, end, flags, newFlag)) & 1) != 0 && (flags & 4) != 0) {
            this.reportError(new ASTError(start, end), Messages.AbstractASTParser_AbstractAsFinalError);
        }
        return flags;
    }
}

