/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.glassfish;

import java.security.AccessController;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public final class GlassfishPlatformDetector
implements ServerPlatformDetector {
    private static final String GF_ROOT_PROP = "com.sun.aas.installRoot";

    @Override
    public String checkPlatform() {
        if (this.isGlassfish()) {
            return "Glassfish";
        }
        return null;
    }

    private boolean isGlassfish() {
        return this.getGlassfishInstallRoot() != null;
    }

    private String getGlassfishInstallRoot() {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(GF_ROOT_PROP)) : System.getProperty(GF_ROOT_PROP);
    }
}

