/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.eclipse.mat.parser.internal.Messages;

public class SimpleBufferedRandomAccessInputStream
extends InputStream {
    private byte[] readBuffer = new byte[32];
    private RandomAccessFile raf;
    private byte[] buffer;
    private int buf_end;
    private int buf_pos;
    private long real_pos;

    public SimpleBufferedRandomAccessInputStream(RandomAccessFile in) throws IOException {
        this(in, 8192);
    }

    public SimpleBufferedRandomAccessInputStream(RandomAccessFile in, int bufsize) throws IOException {
        this.raf = in;
        this.invalidate();
        this.buffer = new byte[bufsize];
    }

    private void invalidate() throws IOException {
        this.buf_end = 0;
        this.buf_pos = 0;
        this.real_pos = this.raf.getFilePointer();
    }

    public final byte[] readDirect(long position, int length) throws IOException {
        byte[] buff = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(buff);
        int totalRead = 0;
        while (totalRead < length) {
            int read = this.raf.getChannel().read(bb, position + (long)totalRead);
            if (read < 0) {
                throw new IOException(Messages.SimpleBufferedRandomAccessInputStream_InvalidReadDirect);
            }
            totalRead += read;
        }
        return buff;
    }

    @Override
    public final int read() throws IOException {
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        return this.buffer[this.buf_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.buf_end == 0) {
            return -1;
        }
        int copied = 0;
        while (copied < len) {
            if (this.buf_pos >= this.buf_end && this.fillBuffer() < 0) {
                return copied;
            }
            int length = Math.min(len - copied, this.buf_end - this.buf_pos);
            System.arraycopy(this.buffer, this.buf_pos, b, off + copied, length);
            this.buf_pos += length;
            copied += length;
        }
        return copied;
    }

    private int fillBuffer() throws IOException {
        int n = this.raf.read(this.buffer);
        if (n >= 0) {
            this.real_pos += (long)n;
            this.buf_end = n;
            this.buf_pos = 0;
        }
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
        this.buffer = null;
    }

    public void seek(long pos) throws IOException {
        int n = (int)(this.real_pos - pos);
        if (n >= 0 && n <= this.buf_end) {
            this.buf_pos = this.buf_end - n;
        } else {
            this.raf.seek(pos);
            this.invalidate();
        }
    }

    public long getFilePointer() {
        return this.real_pos - (long)this.buf_end + (long)this.buf_pos;
    }

    public final int readInt() throws IOException {
        if (this.buf_pos + 4 < this.buf_end) {
            int a = SimpleBufferedRandomAccessInputStream.readInt(this.buffer, this.buf_pos);
            this.buf_pos += 4;
            return a;
        }
        if (this.read(this.readBuffer, 0, 4) != 4) {
            throw new IOException();
        }
        return SimpleBufferedRandomAccessInputStream.readInt(this.readBuffer, 0);
    }

    public final long readLong() throws IOException {
        if (this.buf_pos + 8 < this.buf_end) {
            long a = SimpleBufferedRandomAccessInputStream.readLong(this.buffer, this.buf_pos);
            this.buf_pos += 8;
            return a;
        }
        if (this.read(this.readBuffer, 0, 8) != 8) {
            throw new IOException();
        }
        return SimpleBufferedRandomAccessInputStream.readLong(this.readBuffer, 0);
    }

    public int readIntArray(int[] a) throws IOException {
        int offset = 0;
        int len = a.length * 4;
        byte[] b = null;
        if (this.buf_pos + len < this.buf_end) {
            b = this.buffer;
            offset = this.buf_pos;
            this.buf_pos += len;
        } else {
            byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
            if (this.read(b, 0, len) != len) {
                throw new IOException();
            }
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = SimpleBufferedRandomAccessInputStream.readInt(b, offset + ii * 4);
            ++ii;
        }
        return a.length;
    }

    private static final int readInt(byte[] b, int offset) throws IOException {
        int ch1 = b[offset] & 0xFF;
        int ch2 = b[offset + 1] & 0xFF;
        int ch3 = b[offset + 2] & 0xFF;
        int ch4 = b[offset + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int readLongArray(long[] a) throws IOException {
        int offset = 0;
        int len = a.length * 8;
        byte[] b = null;
        if (this.buf_pos + len < this.buf_end) {
            b = this.buffer;
            offset = this.buf_pos;
            this.buf_pos += len;
        } else {
            byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
            if (this.read(b, 0, len) != len) {
                throw new IOException();
            }
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = SimpleBufferedRandomAccessInputStream.readLong(b, offset + ii * 8);
            ++ii;
        }
        return a.length;
    }

    private static final long readLong(byte[] b, int offset) {
        return ((long)b[offset] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
    }
}

