/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MoveNodeCommand
extends DesignerCommand {
    private IDOMPosition insertPosition;
    private Node originalNode;

    public MoveNodeCommand(IHTMLGraphicalViewer viewer, IDOMPosition insertionPoint, Node originalNode) {
        super(CommandResources.getString("MoveNodeCommand.Label.MoveNode"), viewer);
        this.insertPosition = insertionPoint;
        this.originalNode = originalNode;
    }

    @Override
    protected void doExecute() {
        this.getModel().beginRecording((Object)this);
        try {
            Node originalParent = this.originalNode.getParentNode();
            if (originalParent == null) {
                return;
            }
            if (originalParent == this.insertPosition.getContainerNode()) {
                int insertIndex = this.insertPosition.getOffset();
                int nodeIndex = -1;
                NodeList list = originalParent.getChildNodes();
                int i = 0;
                int length = list.getLength();
                while (i < length) {
                    if (this.originalNode == list.item(i)) {
                        nodeIndex = i;
                    }
                    ++i;
                }
                if (nodeIndex == -1) {
                    return;
                }
                if (insertIndex < nodeIndex) {
                    this.insertPosition = new DOMPosition(originalParent, insertIndex);
                } else {
                    if (insertIndex == nodeIndex || insertIndex == nodeIndex + 1) {
                        return;
                    }
                    this.insertPosition = new DOMPosition(originalParent, insertIndex - 1);
                }
            }
            originalParent.removeChild(this.originalNode);
            DOMUtil.insertNode(this.insertPosition, this.originalNode);
        }
        finally {
            this.getModel().endRecording((Object)this);
        }
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this.originalNode);
    }
}

