/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class AbstractTransferDropTargetListener
implements org.eclipse.jface.util.TransferDropTargetListener,
TransferDropTargetListener {
    private DropTargetEvent currentEvent;
    private AutoexposeHelper exposeHelper;
    private boolean hovering = false;
    private boolean askForCommand;
    private long hoverStartTime = -1L;
    private Point prevMouseLoc;
    private Request request;
    private boolean showingFeedback;
    private EditPart target;
    private Transfer transfer;
    private EditPartViewer viewer;

    public AbstractTransferDropTargetListener(EditPartViewer viewer) {
        this.setViewer(viewer);
    }

    public AbstractTransferDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        this.setViewer(viewer);
        this.setTransfer(xfer);
    }

    private EditPart calculateTargetEditPart() {
        List<IFigure> exclusionFigures = this.getExclusionSet().stream().filter(GraphicalEditPart.class::isInstance).map(ep -> ((GraphicalEditPart)ep).getFigure()).collect(Collectors.toList());
        EditPart ep2 = this.getViewer().findObjectAtExcluding(this.getDropLocation(), exclusionFigures, editpart -> editpart.getTargetEditPart(this.getTargetRequest()) != null);
        if (ep2 != null) {
            ep2 = ep2.getTargetEditPart(this.getTargetRequest());
        }
        return ep2;
    }

    protected Request createTargetRequest() {
        return new Request();
    }

    public void dragEnter(DropTargetEvent event) {
        this.resetHover();
        this.setCurrentEvent(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentEvent(event);
        this.unload();
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.resetHover();
        this.setCurrentEvent(event);
        this.handleDragOperationChanged();
    }

    public void dragOver(DropTargetEvent event) {
        this.setCurrentEvent(event);
        this.handleDragOver();
        if (this.testAndSet(event)) {
            this.resetHover();
        } else {
            if (this.hovering) {
                return;
            }
            long currentTime = event.time;
            if (this.hoverStartTime == -1L) {
                this.hoverStartTime = currentTime;
            } else if (currentTime - this.hoverStartTime > 400L) {
                this.handleHover();
                this.hovering = true;
            }
        }
    }

    public void drop(DropTargetEvent event) {
        this.setCurrentEvent(event);
        this.eraseTargetFeedback();
        this.handleDrop();
        this.unload();
    }

    public void dropAccept(DropTargetEvent event) {
        this.setCurrentEvent(event);
    }

    protected void eraseTargetFeedback() {
        if (this.getTargetEditPart() != null && this.showingFeedback) {
            this.showingFeedback = false;
            this.getTargetEditPart().eraseTargetFeedback(this.getTargetRequest());
        }
    }

    protected Command getCommand() {
        return this.getTargetEditPart().getCommand(this.getTargetRequest());
    }

    public DropTargetEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected Point getDropLocation() {
        org.eclipse.swt.graphics.Point swt = new org.eclipse.swt.graphics.Point(this.getCurrentEvent().x, this.getCurrentEvent().y);
        DropTarget curTarget = (DropTarget)this.getCurrentEvent().widget;
        swt = curTarget.getControl().toControl(swt);
        return new Point(swt.x, swt.y);
    }

    protected Collection<EditPart> getExclusionSet() {
        return Collections.emptySet();
    }

    protected EditPart getTargetEditPart() {
        return this.target;
    }

    protected Request getTargetRequest() {
        if (this.request == null) {
            this.request = this.createTargetRequest();
        }
        return this.request;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    protected EditPartViewer getViewer() {
        return this.viewer;
    }

    protected void handleDragOperationChanged() {
        this.eraseTargetFeedback();
        this.updateTargetRequest();
        this.updateTargetEditPart();
    }

    protected void handleDragOver() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        this.showTargetFeedback();
        if (this.exposeHelper != null && !this.exposeHelper.step(this.getDropLocation())) {
            this.exposeHelper = null;
        }
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.getViewer().getEditDomain().getCommandStack().execute(command);
            } else {
                this.getCurrentEvent().detail = 0;
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
    }

    protected void handleEnteredEditPart() {
    }

    protected void handleExitingEditPart() {
        this.eraseTargetFeedback();
    }

    protected void handleHover() {
        this.updateAutoexposeHelper();
    }

    protected void handleHoverStop() {
    }

    public boolean isEnabled(DropTargetEvent event) {
        TransferData[] transferDataArray = event.dataTypes;
        int n = event.dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TransferData dataType = transferDataArray[n2];
            if (this.getTransfer().isSupportedType(dataType)) {
                Command command;
                this.setCurrentEvent(event);
                event.currentDataType = dataType;
                this.updateTargetRequest();
                EditPart oldTarget = this.target;
                this.updateTargetEditPart();
                boolean result = this.target == null ? false : (this.askForCommand ? (command = this.getCommand()) != null && command.canExecute() : true);
                this.request = null;
                this.target = oldTarget;
                return result;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isEnablementDeterminedByCommand() {
        return this.askForCommand;
    }

    private void resetHover() {
        if (this.hovering) {
            this.handleHoverStop();
            this.hovering = false;
            this.hoverStartTime = -1L;
            this.prevMouseLoc = null;
        }
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        this.exposeHelper = helper;
    }

    protected void setEnablementDeterminedByCommand(boolean value) {
        this.askForCommand = value;
    }

    public void setCurrentEvent(DropTargetEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    protected void setTargetEditPart(EditPart ep) {
        if (ep != this.target) {
            if (this.target != null) {
                this.handleExitingEditPart();
            }
            this.target = ep;
            if (this.target != null) {
                this.handleEnteredEditPart();
            }
        }
    }

    protected void setTransfer(Transfer xfer) {
        this.transfer = xfer;
    }

    protected void setViewer(EditPartViewer viewer) {
        this.viewer = viewer;
    }

    protected void showTargetFeedback() {
        if (this.getTargetEditPart() != null) {
            this.showingFeedback = true;
            this.getTargetEditPart().showTargetFeedback(this.getTargetRequest());
        }
    }

    private boolean testAndSet(DropTargetEvent event) {
        boolean result;
        boolean bl = result = this.prevMouseLoc == null || this.prevMouseLoc.x != event.x || this.prevMouseLoc.y != event.y;
        if (this.prevMouseLoc == null) {
            this.prevMouseLoc = new Point();
        }
        this.prevMouseLoc.x = event.x;
        this.prevMouseLoc.y = event.y;
        return result;
    }

    protected void unload() {
        this.resetHover();
        this.eraseTargetFeedback();
        this.request = null;
        this.setTargetEditPart(null);
        this.setCurrentEvent(null);
        this.setAutoexposeHelper(null);
    }

    protected void updateAutoexposeHelper() {
        if (this.exposeHelper != null) {
            return;
        }
        AutoexposeHelper.Search search = new AutoexposeHelper.Search(this.getDropLocation());
        this.getViewer().findObjectAtExcluding(this.getDropLocation(), Collections.emptyList(), search);
        this.setAutoexposeHelper(search.result);
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    protected abstract void updateTargetRequest();
}

