/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.formatting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xcore.XAnnotationDirective;
import org.eclipse.emf.ecore.xcore.XClassifier;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.conversion.XcoreValueConverterService;
import org.eclipse.emf.ecore.xcore.scoping.XcoreImportedNamespaceAwareScopeProvider;
import org.eclipse.emf.ecore.xcore.util.XcoreUtil;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.TextRegion;

public class XcoreImportOrganizer {
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IQualifiedNameConverter nameConverter;
    @Inject
    private XcoreValueConverterService valueConverterService;
    private Map<String, QualifiedName> implicitAliases;

    protected Map<String, QualifiedName> getImplicitAliases() {
        if (this.implicitAliases == null) {
            this.implicitAliases = Maps.newHashMap();
            EDataType[] eDataTypeArray = XcoreImportedNamespaceAwareScopeProvider.IMPLICIT_ALIASES;
            int n = XcoreImportedNamespaceAwareScopeProvider.IMPLICIT_ALIASES.length;
            int n2 = 0;
            while (n2 < n) {
                EDataType eDataType = eDataTypeArray[n2];
                String instanceClassName = eDataType.getInstanceClassName();
                QualifiedName actualQualifiedName = QualifiedName.create((String[])new String[]{"org", "eclipse", "emf", "ecore", eDataType.getName()});
                QualifiedName qualifiedName = this.nameConverter.toQualifiedName(instanceClassName);
                this.implicitAliases.put(instanceClassName, actualQualifiedName);
                this.implicitAliases.put(qualifiedName.getLastSegment(), actualQualifiedName);
                ++n2;
            }
        }
        return this.implicitAliases;
    }

    protected XPackage getXPackage(XtextResource resource) {
        EObject eObject;
        if (!resource.getContents().isEmpty() && (eObject = (EObject)resource.getContents().get(0)) instanceof XPackage) {
            return (XPackage)eObject;
        }
        return null;
    }

    public TextRegion getImportRegion(XtextResource xtextResource) {
        XPackage xPackage = this.getXPackage(xtextResource);
        if (xPackage != null) {
            int end;
            int begin;
            List xPackageNodes = NodeModelUtils.findNodesForFeature((EObject)xPackage, (EStructuralFeature)XcorePackage.Literals.XNAMED_ELEMENT__NAME);
            int size = xPackageNodes.size();
            if (size == 0) {
                begin = 0;
            } else {
                INode lastNode = (INode)xPackageNodes.get(size - 1);
                begin = lastNode.getOffset() + lastNode.getLength();
            }
            EList<XAnnotationDirective> annotationDirectives = xPackage.getAnnotationDirectives();
            if (!annotationDirectives.isEmpty()) {
                ICompositeNode node = NodeModelUtils.getNode((EObject)((EObject)annotationDirectives.get(0)));
                end = node.getTotalOffset();
            } else {
                EList<XClassifier> classifiers = xPackage.getClassifiers();
                if (!classifiers.isEmpty()) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)((EObject)classifiers.get(0)));
                    end = node.getTotalOffset();
                } else {
                    end = xtextResource.getParseResult().getRootNode().getTotalEndOffset();
                }
            }
            return new TextRegion(begin, end - begin);
        }
        return null;
    }

    public String getOrganizedImportSection(XtextResource xtextResource) {
        String lineSeparator = this.whitespaceInformationProvider.getLineSeparatorInformation(xtextResource.getURI()).getLineSeparator();
        StringBuilder importsSection = new StringBuilder();
        ArrayList importedNames = Lists.newArrayList(this.getImportedNames(xtextResource));
        Collections.sort(importedNames);
        if (!importedNames.isEmpty()) {
            importsSection.append(lineSeparator);
            IValueConverter qualifiedNameValueConverter = this.valueConverterService.getQualifiedNameValueConverter();
            for (QualifiedName qualifiedName : importedNames) {
                String qualifiedNameValue = qualifiedNameValueConverter.toString((Object)this.nameConverter.toString(qualifiedName));
                importsSection.append(lineSeparator).append("import ").append(qualifiedNameValue);
            }
        }
        return importsSection.toString();
    }

    public Set<QualifiedName> getImportedNames(XtextResource resource) {
        XPackage xPackage = this.getXPackage(resource);
        String packageName = xPackage.getName();
        ArrayList implicitPackageImports = Lists.newArrayList((Object[])new String[]{packageName, "java.lang"});
        LinkedHashSet importedNames = Sets.newLinkedHashSet();
        Map<String, QualifiedName> implicitAliases = this.getImplicitAliases();
        for (INode node : XcoreUtil.importableCrossReferences(xPackage)) {
            CrossReference grammarElement = (CrossReference)node.getGrammarElement();
            EObject container = grammarElement.eContainer();
            if (container instanceof Assignment) {
                String name = NodeModelUtils.getTokenText((INode)node);
                if (name.endsWith("::")) {
                    name = name.substring(0, name.length() - 2);
                }
                QualifiedName actualQualifiedName = this.nameConverter.toQualifiedName(name);
                Assignment assignment = (Assignment)container;
                String feature = assignment.getFeature();
                EObject semanticObject = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                EStructuralFeature eStructuralFeature = semanticObject.eClass().getEStructuralFeature(feature);
                if (!eStructuralFeature.isMany()) {
                    QualifiedName fullyQualifiedName;
                    EObject eCrossReference = (EObject)semanticObject.eGet(eStructuralFeature);
                    EObject eContainer = eCrossReference.eContainer();
                    if (eContainer == xPackage || eContainer instanceof XPackage && "xcore.lang".equals(((XPackage)eContainer).getName()) || eContainer instanceof GenPackage && packageName.equals(((GenPackage)eContainer).getQualifiedPackageName()) || eCrossReference instanceof JvmDeclaredType && implicitPackageImports.contains(((JvmDeclaredType)eCrossReference).getPackageName()) || eCrossReference instanceof JvmConstructor && implicitPackageImports.contains(((JvmConstructor)eCrossReference).getDeclaringType().getPackageName()) || (fullyQualifiedName = this.nameProvider.getFullyQualifiedName(eCrossReference)) == null || actualQualifiedName.equals((Object)fullyQualifiedName) || fullyQualifiedName.equals((Object)implicitAliases.get(name))) continue;
                    importedNames.add(fullyQualifiedName);
                    continue;
                }
                throw new RuntimeException("Not expecting multi-valued cross references in these models");
            }
            throw new RuntimeException("Expecting all cross references to be part of an assignment in these models");
        }
        return importedNames;
    }
}

