/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.dbgp.IDbgpStreamFilter;
import org.eclipse.dltk.debug.core.DebugOption;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.eclipse.dltk.debug.core.model.DefaultDebugOptions;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptDebugThreadConfigurator;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.launching.ExternalDebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.dltk.launching.debug.DebuggingUtils;
import org.eclipse.dltk.tcl.activestatedebugger.Messages;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateCommandRenameFilter;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebugThreadConfigurator;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TclActiveStateDebuggerEnvironment;
import org.eclipse.dltk.utils.PlatformFileUtils;

public class TclActiveStateDebuggerRunner
extends ExternalDebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.tcl.activestatedebugger";
    private static final String ADDRESS_KEY = "-dbgp";
    private static final String SHELL_KEY = "-app-shell";
    private static final String IDE_KEY = "-ide-key";
    private static final String SCRIPT_KEY = "-app-file";
    private static final String LOG_KEY = "-log";
    private static final String LOG_FILE_KEY = "-logfile";
    private static final String ARGS_SEPARATOR = "--";

    public TclActiveStateDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig alterConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        IFileHandle pdxFiles;
        IFileHandle file = this.getDebuggingEnginePath(delegate);
        String exe = this.getInstall().getInstallLocation().toOSString();
        DbgpConnectionConfig dbgpConfig = DbgpConnectionConfig.load((InterpreterConfig)config);
        IEnvironment env = this.getInstall().getEnvironment();
        String pathKeyValue = this.getDebuggingPreference(delegate, "debugging_engine_pdx_path");
        String path = (String)EnvironmentPathUtils.decodePaths((String)pathKeyValue).get(env);
        InterpreterConfig newConfig = (InterpreterConfig)config.clone();
        if (path != null && (pdxFiles = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)new Path(path))).exists()) {
            newConfig.addEnvVar("TCLDEVKIT_LOCAL", pdxFiles.toOSString());
        }
        newConfig.setProperty("OVERRIDE_EXE", (Object)file.toString());
        newConfig.addInterpreterArg(ADDRESS_KEY);
        newConfig.addInterpreterArg(String.valueOf(dbgpConfig.getHost()) + ':' + dbgpConfig.getPort());
        newConfig.addInterpreterArg(SHELL_KEY);
        newConfig.addInterpreterArg(exe);
        newConfig.addInterpreterArg(IDE_KEY);
        newConfig.addInterpreterArg(dbgpConfig.getSessionId());
        String logFileName = this.getLogFileName(delegate, dbgpConfig.getSessionId());
        if (logFileName != null) {
            newConfig.addInterpreterArg(LOG_KEY);
            newConfig.addInterpreterArg(LOG_FILE_KEY);
            newConfig.addInterpreterArg(logFileName);
        }
        newConfig.addInterpreterArg(SCRIPT_KEY);
        List args = config.getScriptArgs();
        newConfig.clearScriptArgs();
        newConfig.addScriptArg(ARGS_SEPARATOR);
        newConfig.addScriptArgs(args);
        return newConfig;
    }

    protected IScriptDebugTarget createDebugTarget(ILaunch launch, IDbgpService dbgpService) throws CoreException {
        ScriptDebugTarget target = new ScriptDebugTarget(this.getDebugModelId(), dbgpService, this.getSessionId(launch.getLaunchConfiguration()), launch, null, (IDebugOptions)new TclDebugOptions());
        if (this.createPreferencesLookupDelegate(launch).getBoolean(this.getDebugPreferenceQualifier(), "tcl.debug.stream.filter.command_rename")) {
            target.setStreamFilters(new IDbgpStreamFilter[]{new TclActiveStateCommandRenameFilter()});
        }
        return target;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebuggingEnginePreferenceKey() {
        return "debugging_engine_path";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.tcl.debug";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected IScriptDebugThreadConfigurator createThreadConfigurator(ILaunchConfiguration configuration) {
        IProject project = LaunchConfigurationUtils.getProject((ILaunchConfiguration)configuration);
        return new TclActiveStateDebugThreadConfigurator(DLTKCore.create((IProject)project), (IPreferencesLookupDelegate)new PreferencesLookupDelegate(project));
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        if (code == 500) {
            super.abort(Messages.TclActiveStateDebuggerRunner_errorEngineNotConfigured, exception, code);
        }
        super.abort(message, exception, code);
    }

    protected boolean isLoggingEnabled(IPreferencesLookupDelegate delegate) {
        Map<String, Boolean> values = TclActiveStateDebuggerEnvironment.decodeBooleans(delegate.getString(this.getDebuggingEnginePreferenceQualifier(), "debugging_engine_log_enable"));
        Boolean b = values.get(this.getInstall().getEnvironmentId());
        return b == null || b != false;
    }

    protected String getProcessType() {
        return "tclInterpreter";
    }

    protected IFileHandle getDebuggingEnginePath(PreferencesLookupDelegate delegate) {
        IFileHandle handle = super.getDebuggingEnginePath(delegate);
        if (handle == null) {
            String paths = delegate.getString(this.getDebuggingEnginePreferenceQualifier(), this.getDebuggingEnginePreferenceKey());
            IEnvironment env = this.getInstall().getEnvironment();
            String path = (String)EnvironmentPathUtils.decodePaths((String)paths).get(env);
            if (path == null && (path = DebuggingUtils.getDefaultEnginePath((IEnvironment)env, (String)ENGINE_ID)) != null && path.length() != 0) {
                return PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)new Path(path));
            }
        }
        return handle;
    }

    private static class TclDebugOptions
    extends DefaultDebugOptions {
        private static final String CONSOLE = "<console>";

        private TclDebugOptions() {
        }

        public boolean get(IDebugOptions.BooleanOption option) {
            if (option == DebugOption.DBGP_ASYNC) {
                return false;
            }
            if (option == DebugOption.DBGP_BREAKPOINT_UPDATE_LINE_NUMBER) {
                return false;
            }
            if (option == DebugOption.ENGINE_SUPPORT_DATATYPES) {
                return false;
            }
            if (option == DebugOption.ENGINE_STOP_BEFORE_CODE) {
                return false;
            }
            if (option == DebugOption.ENGINE_VALIDATE_STACK) {
                return true;
            }
            return super.get(option);
        }

        public IScriptStackFrame[] filterStackLevels(IScriptStackFrame[] frames) {
            int lastIndex;
            URI uri;
            if (frames.length > 1 && "unknown".equals((uri = frames[lastIndex = frames.length - 1].getSourceURI()).getScheme()) && CONSOLE.equals(uri.getFragment())) {
                IScriptStackFrame[] result = new IScriptStackFrame[lastIndex];
                System.arraycopy(frames, 0, result, 0, lastIndex);
                return result;
            }
            return super.filterStackLevels(frames);
        }

        public boolean isValidStack(IScriptStackFrame[] frames) {
            URI uri;
            return frames.length != 1 || !"unknown".equals((uri = frames[0].getSourceURI()).getScheme()) || !CONSOLE.equals(uri.getFragment());
        }
    }
}

