/*******************************************************************************
 * Copyright (c) 2024 Advantest Europe GmbH and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * Dietrich Travkin (Solunar GmbH) - Initial implementation
 *******************************************************************************/
package org.eclipse.cdt.lsp.services.symbolinfo;

import org.eclipse.cdt.lsp.services.ClangdLanguageServer;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Data type used in {@link SymbolDetails} for the <em>textDocument/symbolInfo</em> request.
 * This class was generated by the <em>org.eclipse.lsp4j.generator</em> bundle
 * using xtend (see {@link org.eclipse.lsp4j.generator.JsonRpcData JsonRpcData} and
 * the <a href="https://github.com/eclipse-lsp4j/lsp4j/blob/main/documentation/jsonrpc.md">documentation</a>).
 *
 * @see {@link SymbolDetails}
 * @see {@link ClangdLanguageServer#getSymbolInfo(org.eclipse.lsp4j.TextDocumentPositionParams)}
 */
public class RangeAndUri {
	@NonNull
	private Range range;

	@NonNull
	private String uri;

	@NonNull
	public Range getRange() {
		return this.range;
	}

	public void setRange(@NonNull final Range range) {
		this.range = Preconditions.<Range>checkNotNull(range, "range"); //$NON-NLS-1$
	}

	@NonNull
	public String getUri() {
		return this.uri;
	}

	public void setUri(@NonNull final String uri) {
		this.uri = Preconditions.<String>checkNotNull(uri, "uri"); //$NON-NLS-1$
	}

	@Override
	public String toString() {
		ToStringBuilder b = new ToStringBuilder(this);
		b.add("range", this.range); //$NON-NLS-1$
		b.add("uri", this.uri); //$NON-NLS-1$
		return b.toString();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		RangeAndUri other = (RangeAndUri) obj;
		if (this.range == null) {
			if (other.range != null)
				return false;
		} else if (!this.range.equals(other.range))
			return false;
		if (this.uri == null) {
			if (other.uri != null)
				return false;
		} else if (!this.uri.equals(other.uri))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.range == null) ? 0 : this.range.hashCode());
		return prime * result + ((this.uri == null) ? 0 : this.uri.hashCode());
	}
}
