/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.Hashtable;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.IVisualizerModelObject;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvas;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view.MulticoreVisualizerCanvasFilter;
import org.eclipse.cdt.dsf.service.DsfSession;

public class MulticoreVisualizerCanvasFilterManager
implements DsfSession.SessionEndedListener {
    private Hashtable<String, MulticoreVisualizerCanvasFilter> m_filterSessionMap = new Hashtable();
    private MulticoreVisualizerCanvas m_canvas = null;
    private MulticoreVisualizerCanvasFilter m_currentFilter = null;

    public MulticoreVisualizerCanvasFilterManager(MulticoreVisualizerCanvas canvas) {
        this.m_canvas = canvas;
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public void dispose() {
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
        if (this.m_filterSessionMap != null) {
            for (MulticoreVisualizerCanvasFilter filter : this.m_filterSessionMap.values()) {
                filter.dispose();
            }
            this.m_filterSessionMap.clear();
            this.m_filterSessionMap = null;
        }
        this.m_canvas = null;
        this.m_currentFilter = null;
    }

    public MulticoreVisualizerCanvasFilter getFilter(String sessionId) {
        MulticoreVisualizerCanvasFilter filter = null;
        filter = this.m_filterSessionMap.get(sessionId);
        if (filter == null) {
            filter = new MulticoreVisualizerCanvasFilter(this.m_canvas);
            this.m_filterSessionMap.put(sessionId, filter);
        }
        return filter;
    }

    public void removeFilter(String sessionId) {
        if (this.m_filterSessionMap.containsKey(sessionId)) {
            this.m_filterSessionMap.remove(sessionId);
        }
    }

    public void updateCurrentFilter() {
        if (this.m_currentFilter != null) {
            this.m_currentFilter.updateFilter();
        }
    }

    public void applyFilter() {
        if (this.m_currentFilter != null) {
            this.m_currentFilter.applyFilter();
        }
    }

    public void clearFilter() {
        if (this.m_currentFilter != null) {
            this.m_currentFilter.clearFilter();
        }
    }

    public void setCurrentFilter(String sessionId) {
        this.m_currentFilter = sessionId == null ? null : this.getFilter(sessionId);
    }

    public MulticoreVisualizerCanvasFilter getCurrentFilter() {
        return this.m_currentFilter;
    }

    public boolean isCurrentFilterActive() {
        if (this.m_currentFilter != null) {
            return this.m_currentFilter.isFilterActive();
        }
        return false;
    }

    public boolean displayObject(IVisualizerModelObject obj) {
        if (this.m_currentFilter != null) {
            return this.m_currentFilter.displayObject(obj);
        }
        return false;
    }

    public void sessionEnded(DsfSession session) {
        this.removeFilter(session.getId());
    }
}

