/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.ant.app;

import java.io.PrintStream;
import org.eclipse.emf.common.util.Diagnostic;

public interface IDiagnosticReporter {
    public void report(Diagnostic var1);

    public static abstract class AbstractReporter
    implements IDiagnosticReporter {
        public void report(Diagnostic diagnostic) {
            this.report(0, diagnostic);
        }

        protected void report(int depth, Diagnostic diagnostic) {
            this.doReport(depth, diagnostic.getSeverity(), diagnostic.getMessage(), diagnostic.getException());
            if (!diagnostic.getChildren().isEmpty()) {
                for (Diagnostic next : diagnostic.getChildren()) {
                    this.report(depth + 1, next);
                }
            }
        }

        protected abstract void doReport(int var1, int var2, String var3, Throwable var4);

        protected String toSeverityString(int severity) {
            switch (severity) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "INFO";
                }
                case 2: {
                    return "WARN";
                }
            }
            return "ERROR";
        }
    }

    public static class PrintStreamReporter
    extends AbstractReporter {
        private final PrintStream stream;

        public PrintStreamReporter(PrintStream stream) {
            this.stream = stream;
        }

        protected void doReport(int depth, int severity, String message, Throwable exception) {
            this.stream.printf("%" + 2 * depth + "s[%5s] %s%n", "", this.toSeverityString(severity), message);
        }

        protected String toSeverityString(int severity) {
            switch (severity) {
                case 0: {
                    return "OK";
                }
                case 1: {
                    return "INFO";
                }
                case 2: {
                    return "WARN";
                }
            }
            return "ERROR";
        }
    }
}

