/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.ICWatchpointTarget;
import org.eclipse.cdt.debug.core.model.IReverseResumeHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepIntoHandler;
import org.eclipse.cdt.debug.core.model.IReverseStepOverHandler;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.IUncallHandler;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.tcf.internal.cdt.ui.TCFSteppingModeTarget;
import org.eclipse.tcf.internal.cdt.ui.TCFSuspendResumeAdapter;
import org.eclipse.tcf.internal.cdt.ui.breakpoints.TCFWatchpointTarget;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFPinViewCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseResumeCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepIntoCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepOverCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseStepReturnCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFReverseToggleCommand;
import org.eclipse.tcf.internal.cdt.ui.commands.TCFStepIntoSelectionHandler;
import org.eclipse.tcf.internal.cdt.ui.disassembly.TCFDisassemblyBackend;
import org.eclipse.tcf.internal.cdt.ui.hover.TCFDebugTextHover;
import org.eclipse.tcf.internal.cdt.ui.sourcelookup.TCFSourceNotFoundPresentation;
import org.eclipse.tcf.internal.debug.ui.model.ISourceNotFoundPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;

public class TCFNodeAdapterFactory
implements IAdapterFactory {
    private static final String STEP_INTO_SELECTION = "org.eclipse.cdt.debug.core.model.IStepIntoSelectionHandler";
    private static final Object[] class_names = new Object[]{IDisassemblyBackend.class, ISteppingModeTarget.class, ISuspendResume.class, ICEditorTextHover.class, IReverseToggleHandler.class, IReverseStepIntoHandler.class, IReverseStepOverHandler.class, IReverseResumeHandler.class, "org.eclipse.cdt.debug.core.model.IStepIntoSelectionHandler", IUncallHandler.class, IPinProvider.class, ICWatchpointTarget.class, ISourceNotFoundPresentation.class};
    private static final Class[] class_list;

    static {
        ArrayList l = new ArrayList();
        Object[] objectArray = class_names;
        int n = class_names.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Class) {
                l.add((Class)o);
            } else {
                try {
                    l.add(Class.forName((String)o));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        class_list = l.toArray(new Class[l.size()]);
    }

    public Object getAdapter(Object obj, Class type) {
        if (obj instanceof TCFNode) {
            TCFNode node = (TCFNode)obj;
            TCFModel model = node.getModel();
            Object handler = model.getAdapter(type, node);
            if (handler == null) {
                if (IDisassemblyBackend.class == type) {
                    TCFDisassemblyBackend backend = new TCFDisassemblyBackend();
                    if (backend.supportsDebugContext((IAdaptable)node)) {
                        return backend;
                    }
                    backend.dispose();
                } else if (ISteppingModeTarget.class == type) {
                    handler = new TCFSteppingModeTarget(model);
                    model.setAdapter(type, handler);
                } else if (ISuspendResume.class == type) {
                    TCFNodeExecContext exec = null;
                    if (node instanceof TCFNodeExecContext) {
                        exec = (TCFNodeExecContext)node;
                    } else if (node instanceof TCFNodeStackFrame) {
                        exec = (TCFNodeExecContext)node.getParent();
                    }
                    if (exec != null) {
                        return new TCFSuspendResumeAdapter(exec);
                    }
                } else if (ICEditorTextHover.class == type) {
                    handler = new TCFDebugTextHover();
                    model.setAdapter(type, handler);
                } else if (IReverseToggleHandler.class == type) {
                    handler = new TCFReverseToggleCommand();
                    model.setAdapter(type, handler);
                } else if (IReverseStepIntoHandler.class == type) {
                    handler = new TCFReverseStepIntoCommand(model);
                    model.setAdapter(type, handler);
                } else if (IReverseStepOverHandler.class == type) {
                    handler = new TCFReverseStepOverCommand(model);
                    model.setAdapter(type, handler);
                } else if (IUncallHandler.class == type) {
                    handler = new TCFReverseStepReturnCommand(model);
                    model.setAdapter(type, handler);
                } else if (IReverseResumeHandler.class == type) {
                    handler = new TCFReverseResumeCommand(model);
                    model.setAdapter(type, handler);
                } else if (IPinProvider.class == type) {
                    handler = new TCFPinViewCommand(model);
                    model.setAdapter(type, handler);
                } else if (ICWatchpointTarget.class == type) {
                    if (node instanceof TCFNodeExpression) {
                        return new TCFWatchpointTarget((TCFNodeExpression)node);
                    }
                } else if (ISourceNotFoundPresentation.class == type) {
                    handler = new TCFSourceNotFoundPresentation();
                    model.setAdapter(type, handler);
                } else if (type.getName().equals(STEP_INTO_SELECTION)) {
                    handler = new TCFStepIntoSelectionHandler();
                    model.setAdapter(type, handler);
                }
            }
            return handler;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return class_list;
    }
}

