/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class QVTbaseHelper
extends PivotHelper {
    public QVTbaseHelper(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public @NonNull Function createFunction(@NonNull String name, @NonNull Type returnType, boolean returnIsRequired, @Nullable List<@NonNull FunctionParameter> asParameters) {
        Function asFunction = QVTbaseFactory.eINSTANCE.createFunction();
        asFunction.setName(name);
        this.setType((TypedElement)asFunction, returnType, returnIsRequired);
        if (asParameters != null) {
            asFunction.getOwnedParameters().addAll(asParameters);
        }
        return asFunction;
    }

    public @NonNull FunctionParameter createFunctionParameter(@NonNull String name, @NonNull Class asClass, boolean isRequired) {
        FunctionParameter asParameter = QVTbaseFactory.eINSTANCE.createFunctionParameter();
        asParameter.setName(name);
        this.setType((TypedElement)asParameter, (Type)asClass, isRequired);
        return asParameter;
    }

    public @NonNull FunctionParameter createFunctionParameter(@NonNull TypedElement typedElement) {
        String name = (String)ClassUtil.nonNullState((Object)typedElement.getName());
        Type type = (Type)ClassUtil.nonNullState((Object)typedElement.getType());
        FunctionParameter asParameter = QVTbaseFactory.eINSTANCE.createFunctionParameter();
        asParameter.setName(name);
        this.setType((TypedElement)asParameter, type, typedElement.isIsRequired());
        return asParameter;
    }

    public @NonNull IteratorExp createIteratorExp(@NonNull OCLExpression asSourceExpression, @NonNull String opName, @NonNull List<@NonNull ? extends Variable> asIterators, @NonNull OCLExpression asBody) {
        Type asType = (Type)ClassUtil.nonNullState((Object)asSourceExpression.getType());
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(asType);
        int iteratorsCount = asIterators.size();
        int bestMatches = -1;
        Iteration bestIteration = null;
        for (Operation asOperation : completeClass.getOperations(FeatureFilter.SELECT_NON_STATIC, opName)) {
            Iteration asIteration;
            List asParameters;
            if (!(asOperation instanceof Iteration) || (asParameters = ClassUtil.nullFree((List)(asIteration = (Iteration)asOperation).getOwnedIterators())).size() != iteratorsCount) continue;
            int exactMatches = 0;
            boolean gotOne = true;
            int i = 0;
            while (i < iteratorsCount) {
                Type asArgumentType;
                Type asParameterType = (Type)ClassUtil.nonNullState((Object)((Parameter)asParameters.get(i)).getType());
                if (asParameterType instanceof SelfType) {
                    asArgumentType = asIterators.get(i).getType();
                    if (asArgumentType.conformsTo(this.standardLibrary, asType) && asType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                } else {
                    asArgumentType = asIterators.get(i).getType();
                    if (!asArgumentType.conformsTo(this.standardLibrary, asParameterType)) {
                        gotOne = false;
                        break;
                    }
                    if (asParameterType.conformsTo(this.standardLibrary, asArgumentType)) {
                        ++exactMatches;
                    }
                }
                ++i;
            }
            if (!gotOne) continue;
            if (exactMatches > bestMatches) {
                bestMatches = exactMatches;
                bestIteration = asIteration;
                continue;
            }
            if (exactMatches <= bestMatches) continue;
            bestIteration = null;
        }
        if (bestMatches < 0) {
            throw new IllegalStateException("No match found for " + opName);
        }
        if (bestIteration == null) {
            throw new IllegalStateException("Ambiguous match found for " + opName);
        }
        return this.createIteratorExp(asSourceExpression, bestIteration, asIterators, asBody);
    }

    public @NonNull Pattern createPattern() {
        Pattern asPattern = QVTbaseFactory.eINSTANCE.createPattern();
        return asPattern;
    }

    public @NonNull Predicate createPredicate(@NonNull OCLExpression asConditionExpression) {
        Predicate asPredicate = QVTbaseFactory.eINSTANCE.createPredicate();
        asPredicate.setConditionExpression(asConditionExpression);
        return asPredicate;
    }

    public @NonNull TypedModel createPrimitiveTypedModel() {
        TypedModel asTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        asTypedModel.setName("$primitive$");
        asTypedModel.setIsPrimitive(true);
        return asTypedModel;
    }

    public @NonNull TypedModel createThisTypedModel() {
        TypedModel asTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        asTypedModel.setName("$this$");
        asTypedModel.setIsThis(true);
        return asTypedModel;
    }

    public @NonNull Transformation createTransformation(@NonNull String name) {
        Transformation transformation = QVTbaseFactory.eINSTANCE.createTransformation();
        transformation.setName(name);
        return transformation;
    }

    public @NonNull TypedModel createTypedModel(@NonNull String name, @NonNull Iterable<@NonNull Package> usedPackages) {
        TypedModel asTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        asTypedModel.setName(name);
        Iterables.addAll(QVTbaseUtil.Internal.getUsedPackagesList(asTypedModel), usedPackages);
        return asTypedModel;
    }

    public @NonNull CompleteClass getCompleteClass(@NonNull Type type) {
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        return completeClass;
    }
}

