/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.codeassist;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.scope.ScopeParser;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class CompletionCompanion {
    private Map<Integer, IType[]> rhTypesCache = new HashMap<Integer, IType[]>();
    private Map<IType, ITypeHierarchy> superHierarchyCache = new HashMap<IType, ITypeHierarchy>();
    private IStructuredDocument document;
    private int offset;
    private String currentNamespaceName;
    private ISourceRange currentNamespaceRange;
    private PHPVersion phpVersion;
    private ISourceModule sourceModule;
    private IStructuredDocumentRegion structuredDocumentRegion;
    private ITextRegionCollection regionCollection;
    private IPHPScriptRegion phpScriptRegion;
    private String partitionType;
    private PHPModuleDeclaration phpModuleDeclaration;
    private ICompletionScope scope;

    public CompletionCompanion(CompletionRequestor requestor, IModuleSource moduleSource, int offset) {
        this.offset = offset;
        this.sourceModule = (ISourceModule)moduleSource.getModelElement();
        this.phpVersion = ProjectOptions.getPHPVersion(this.getSourceModule().getScriptProject().getProject());
        try {
            this.document = this.determineDocument(this.sourceModule, requestor);
            if (this.document == null) {
                return;
            }
            this.structuredDocumentRegion = this.determineStructuredDocumentRegion(this.document, offset);
            if (this.structuredDocumentRegion == null) {
                return;
            }
            this.regionCollection = this.determineRegionCollection(this.document, this.structuredDocumentRegion, offset);
            if (this.regionCollection == null) {
                return;
            }
            this.phpScriptRegion = this.determinePHPRegion(this.document, this.regionCollection, offset);
            if (this.phpScriptRegion == null) {
                return;
            }
            this.partitionType = this.determinePartitionType(this.regionCollection, this.phpScriptRegion, offset);
            if (this.partitionType != null) {
                this.determineScope();
                this.determineNamespace();
            }
        }
        catch (IOException | CoreException | BadLocationException | ResourceAlreadyExists e) {
            Logger.logException(e);
        }
    }

    public final IStructuredDocument getDocument() {
        return this.document;
    }

    public final ITextRegionCollection getRegionCollection() {
        return this.regionCollection;
    }

    public final IPHPScriptRegion getPHPScriptRegion() {
        return this.phpScriptRegion;
    }

    public final String getPartitionType() {
        return this.partitionType;
    }

    public final IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.structuredDocumentRegion;
    }

    public final PHPVersion getPHPVersion() {
        return this.phpVersion;
    }

    public final int getOffset() {
        return this.offset;
    }

    private IStructuredDocument determineDocument(ISourceModule module, CompletionRequestor requestor) throws ResourceAlreadyExists, IOException, CoreException {
        IDocument d;
        IStructuredDocument document = null;
        if (requestor instanceof IPHPCompletionRequestor && (d = ((IPHPCompletionRequestor)requestor).getDocument()) instanceof IStructuredDocument) {
            document = (IStructuredDocument)d;
        }
        if (document == null) {
            IStructuredModel structuredModel = null;
            try {
                IFile file = (IFile)module.getResource();
                if (file != null) {
                    if (file.exists()) {
                        structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                        document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                    } else {
                        document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                        document.set(module.getSource());
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
            }
        }
        return document;
    }

    private IStructuredDocumentRegion determineStructuredDocumentRegion(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion = null;
        int lastOffset = offset;
        while (sdRegion == null && lastOffset >= 0) {
            sdRegion = document.getRegionAtCharacterOffset(lastOffset);
            --lastOffset;
        }
        return sdRegion;
    }

    private ITextRegionCollection determineRegionCollection(IStructuredDocument document, IStructuredDocumentRegion sdRegion, int offset) {
        IStructuredDocumentRegion regionCollection = sdRegion;
        ITextRegion textRegion = this.determineTextRegion(document, (ITextRegionCollection)sdRegion, offset);
        if (textRegion instanceof ITextRegionContainer) {
            regionCollection = (ITextRegionContainer)textRegion;
        }
        return regionCollection;
    }

    private ITextRegion determineTextRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = offset == document.getLength() ? regionCollection.getLastRegion() : regionCollection.getRegionAtCharacterOffset(offset);
        return textRegion;
    }

    private IPHPScriptRegion determinePHPRegion(IStructuredDocument document, ITextRegionCollection regionCollection, int offset) {
        ITextRegion textRegion = this.determineTextRegion(document, regionCollection, offset);
        IPHPScriptRegion phpScriptRegion = null;
        if (textRegion != null) {
            if (textRegion.getType() == "PHP_OPEN") {
                return null;
            }
            if (textRegion.getType() == "PHP_CLOSE") {
                if (regionCollection.getStartOffset(textRegion) == offset) {
                    textRegion = regionCollection.getRegionAtCharacterOffset(offset - 1);
                } else {
                    return null;
                }
            }
        }
        if (textRegion instanceof IPHPScriptRegion) {
            phpScriptRegion = (IPHPScriptRegion)textRegion;
        }
        return phpScriptRegion;
    }

    private String determinePartitionType(ITextRegionCollection regionCollection, IPHPScriptRegion phpScriptRegion, int offset) throws BadLocationException {
        String regionType;
        int internalOffset = this.getOffset(offset, regionCollection, phpScriptRegion);
        String partitionType = phpScriptRegion.getPartition(internalOffset);
        if ((partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || partitionType == "org.eclipse.php.PHP_DOC") && (PHPPartitionTypes.isPHPMultiLineCommentStartRegion(regionType = phpScriptRegion.getPHPToken(internalOffset).getType()) || PHPPartitionTypes.isPHPDocStartRegion(regionType)) && phpScriptRegion.getPHPToken(internalOffset).getStart() == internalOffset) {
            partitionType = phpScriptRegion.getPartition(internalOffset - 1);
        }
        return partitionType;
    }

    private void determineNamespace() {
        ICompletionScope parent = this.scope.findParent(ICompletionScope.Type.NAMESPACE);
        if (parent != null) {
            this.currentNamespaceName = parent.getName();
            this.currentNamespaceRange = parent;
        } else {
            this.currentNamespaceRange = this.scope.findParent(ICompletionScope.Type.FILE);
        }
    }

    @NonNull
    public final ISourceModule getSourceModule() {
        return this.sourceModule;
    }

    public IType[] getLeftHandType(ICompletionContext context) {
        AbstractCompletionContext aContext = (AbstractCompletionContext)context;
        if (!this.rhTypesCache.containsKey(this.offset)) {
            TextSequence statementText = aContext.getStatementText();
            return this.getLeftHandType(statementText, this.offset, false);
        }
        return this.rhTypesCache.get(this.offset);
    }

    private IType[] getLeftHandType(TextSequence statementText, int offset, boolean isType) {
        if (!this.rhTypesCache.containsKey(offset)) {
            int triggerEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementText.length());
            triggerEnd = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, triggerEnd, true);
            triggerEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, triggerEnd);
            if (isType) {
                this.rhTypesCache.put(offset, CodeAssistUtils.getTypesFor(this.getSourceModule(), statementText, triggerEnd, offset));
            } else {
                this.rhTypesCache.put(offset, CodeAssistUtils.getTraitsFor(this.getSourceModule(), statementText, triggerEnd, offset));
            }
        }
        return this.rhTypesCache.get(offset);
    }

    public IType[] getLeftHandType(ICompletionContext context, boolean isType) {
        AbstractCompletionContext aContext = (AbstractCompletionContext)context;
        if (!this.rhTypesCache.containsKey(this.offset)) {
            TextSequence statementText = aContext.getStatementText();
            return this.getLeftHandType(statementText, this.offset, isType);
        }
        return this.rhTypesCache.get(this.offset);
    }

    public ITypeHierarchy getSuperTypeHierarchy(IType type, IProgressMonitor monitor) throws ModelException {
        if (!PHPToolkitUtil.isFromPHPProject((IModelElement)type)) {
            return new FakeTypeHierarchy();
        }
        if (!this.superHierarchyCache.containsKey(type)) {
            this.superHierarchyCache.put(type, type.newSupertypeHierarchy(monitor));
        }
        return this.superHierarchyCache.get(type);
    }

    private int getOffset(int offset, ITextRegionCollection regionCollection, IPHPScriptRegion phpScriptRegion) {
        int result = offset - regionCollection.getStartOffset() - phpScriptRegion.getStart() - 1;
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public final ITextRegion getPHPToken() throws BadLocationException {
        return this.getPHPToken(this.offset);
    }

    public ITextRegion getPHPToken(int offset) throws BadLocationException {
        return this.phpScriptRegion.getPHPToken(this.getOffset(offset, this.regionCollection, this.phpScriptRegion));
    }

    public boolean isGlobalNamespace() {
        return this.getCurrentNamespace() == null;
    }

    public String getCurrentNamespace() {
        return this.currentNamespaceName;
    }

    public ISourceRange getCurrentNamespaceRange() {
        return this.currentNamespaceRange;
    }

    public PHPModuleDeclaration getModuleDeclaration() {
        ModuleDeclaration moduleDeclaration;
        if (this.phpModuleDeclaration == null && (moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)this.getSourceModule(), null)) instanceof PHPModuleDeclaration) {
            this.phpModuleDeclaration = (PHPModuleDeclaration)moduleDeclaration;
        }
        return this.phpModuleDeclaration;
    }

    private void determineScope() {
        ScopeParser scopeParser = new ScopeParser((IDocument)this.document);
        this.scope = scopeParser.parse(this.offset);
    }

    @NonNull
    public ICompletionScope getScope() {
        if (this.scope == null) {
            this.determineScope();
            this.currentNamespaceRange = this.scope;
        }
        return this.scope;
    }

    private static class FakeTypeHierarchy
    extends TypeHierarchy {
        public FakeTypeHierarchy() {
            this.initialize(1);
        }
    }
}

