/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductContentType;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.simpleconfigurator.manipulator.SimpleConfiguratorManipulator;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.ifeature.IEnvironment;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IVersionable;
import org.eclipse.pde.internal.core.plugin.PluginBase;

public class P2Utils {
    public static final String P2_FLAVOR_DEFAULT = "tooling";
    public static final ITouchpointType TOUCHPOINT_OSGI = MetadataFactory.createTouchpointType((String)"org.eclipse.equinox.p2.osgi", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String NAMESPACE_ECLIPSE_TYPE = "org.eclipse.equinox.p2.eclipse.type";
    public static final IProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final String CAPABILITY_NS_JAVA_PACKAGE = "java.package";

    public static BundleInfo[] readBundles(String platformHome, File configurationArea) {
        BundleInfo[] bundles;
        block4: {
            IPath basePath = IPath.fromOSString((String)platformHome);
            if (configurationArea == null) {
                return null;
            }
            try {
                File bundlesTxt = new File(configurationArea, "org.eclipse.equinox.simpleconfigurator/bundles.info");
                File home = basePath.toFile();
                bundles = P2Utils.getBundlesFromFile(bundlesTxt, home);
                if (bundles != null && bundles.length != 0) break block4;
                return null;
            }
            catch (IOException e) {
                PDECore.log(e);
                return null;
            }
        }
        return bundles;
    }

    public static BundleInfo[] readSourceBundles(String platformHome, File configurationArea) {
        BundleInfo[] srcBundles;
        block4: {
            IPath basePath = IPath.fromOSString((String)platformHome);
            if (configurationArea == null) {
                return null;
            }
            try {
                File home = basePath.toFile();
                File srcBundlesTxt = new File(configurationArea, "org.eclipse.equinox.source/source.info");
                srcBundles = P2Utils.getBundlesFromFile(srcBundlesTxt, home);
                if (srcBundles != null && srcBundles.length != 0) break block4;
                return null;
            }
            catch (IOException e) {
                PDECore.log(e);
                return null;
            }
        }
        return srcBundles;
    }

    private static BundleInfo[] getBundlesFromFile(File filePath, File home) throws IOException {
        SimpleConfiguratorManipulator manipulator = PDECore.getDefault().acquireService(SimpleConfiguratorManipulator.class);
        if (manipulator == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream in = Files.newInputStream(filePath.toPath(), new OpenOption[0]);){
                return manipulator.loadConfiguration(in, home.toURI());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    public static URL writeBundlesTxt(Map<IPluginModelBase, String> bundles, int defaultStartLevel, boolean defaultAutoStart, File directory, String osgiBundleList) {
        if (bundles.isEmpty()) {
            return null;
        }
        HashMap<Object, CallSite> osgiStartLevels = new HashMap<Object, CallSite>();
        if (osgiBundleList != null) {
            StringTokenizer tokenizer = new StringTokenizer(osgiBundleList, ",");
            while (tokenizer.hasMoreTokens()) {
                String auto;
                String token = tokenizer.nextToken();
                int index = token.indexOf(64);
                if (index == -1) continue;
                String modelName = token.substring(0, index);
                String startData = token.substring(index + 1);
                String level = (index = startData.indexOf(58)) > 0 ? startData.substring(0, index) : "default";
                String string = auto = index > 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
                if ("start".equals(auto)) {
                    auto = "true";
                }
                osgiStartLevels.put(modelName, (CallSite)((Object)(level + ":" + auto)));
            }
        }
        ArrayList<BundleInfo> bundleInfo = new ArrayList<BundleInfo>(bundles.size());
        ArrayList<BundleInfo> sourceInfo = new ArrayList<BundleInfo>(bundles.size());
        for (IPluginModelBase currentModel : bundles.keySet()) {
            IPluginBase base = currentModel.getPluginBase();
            BundleInfo info = new BundleInfo();
            String installLocation = currentModel.getInstallLocation();
            if (installLocation != null) {
                int index;
                info.setLocation(new File(installLocation).toURI());
                if (base instanceof PluginBase && ((PluginBase)base).getBundleSourceEntry() != null) {
                    info.setSymbolicName(base.getId());
                    info.setVersion(base.getVersion());
                    info.setStartLevel(-1);
                    info.setMarkedAsStarted(false);
                    sourceInfo.add(info);
                    continue;
                }
                if (base == null) continue;
                info.setSymbolicName(base.getId());
                info.setVersion(base.getVersion());
                String currentLevel = bundles.get(currentModel);
                if (osgiStartLevels.containsKey(base.getId())) {
                    currentLevel = (String)osgiStartLevels.get(base.getId());
                }
                String levelString = (index = currentLevel.indexOf(58)) > 0 ? currentLevel.substring(0, index) : "default";
                String auto = index > 0 && index < currentLevel.length() - 1 ? currentLevel.substring(index + 1) : "default";
                boolean isAuto = true;
                int level = -1;
                isAuto = "default".equals(auto) ? defaultAutoStart : Boolean.parseBoolean(auto);
                if ("default".equals(levelString)) {
                    level = defaultStartLevel;
                } else {
                    try {
                        level = Integer.parseInt(levelString);
                    }
                    catch (NumberFormatException e) {
                        PDECore.log(Status.error((String)("Error writing bundles, could not parse start level for bundle " + String.valueOf(currentModel))));
                    }
                }
                info.setMarkedAsStarted(isAuto);
                info.setStartLevel(level);
                bundleInfo.add(info);
                continue;
            }
            PDECore.log(Status.error((String)("Error writing bundles, could not find the bundle location for bundle " + String.valueOf(currentModel))));
        }
        File bundlesTxt = new File(directory, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        File srcBundlesTxt = new File(directory, "org.eclipse.equinox.source/source.info");
        BundleInfo[] infos = bundleInfo.toArray(new BundleInfo[bundleInfo.size()]);
        BundleInfo[] sources = sourceInfo.toArray(new BundleInfo[sourceInfo.size()]);
        SimpleConfiguratorManipulator manipulator = (SimpleConfiguratorManipulator)BundleHelper.getDefault().acquireService(SimpleConfiguratorManipulator.class);
        try {
            manipulator.saveConfiguration(infos, bundlesTxt, null);
            manipulator.saveConfiguration(sources, srcBundlesTxt, null);
        }
        catch (IOException e) {
            PDECore.logException(e);
            return null;
        }
        if (!bundlesTxt.exists()) {
            return null;
        }
        try {
            return bundlesTxt.toURL();
        }
        catch (MalformedURLException e) {
            PDECore.logException(e);
            return null;
        }
    }

    public static boolean profileExists(String profileID, File p2DataArea) throws CoreException {
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        if (provider == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProvisioningAgent agent = provider.createAgent(p2DataArea.toURI());
        if (agent == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        return registry.containsProfile(profileID);
    }

    public static void createProfile(String profileID, File p2DataArea, Collection<List<IPluginModelBase>> bundles) throws CoreException {
        P2Utils.createProfile(profileID, p2DataArea, bundles, null, null);
    }

    public static void createProfile(String profileID, File p2DataArea, Collection<List<IPluginModelBase>> bundles, Map<IFeature, Boolean> featureMap, final ProductInfo productInfo) throws CoreException {
        IPhaseSet phaseSet;
        IStatus status;
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        if (provider == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProvisioningAgent agent = provider.createAgent(p2DataArea.toURI());
        if (agent == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new CoreException(Status.error((String)PDECoreMessages.P2Utils_UnableToAcquireP2Service));
        }
        registry.removeProfile(profileID);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
        props.put("org.eclipse.equinox.p2.environments", P2Utils.generateEnvironmentProperties());
        props.put("org.eclipse.equinox.p2.nl", TargetPlatform.getNL());
        IProfile profile = registry.addProfile(profileID, props);
        Collection ius = bundles.stream().flatMap(Collection::stream).map(IPluginModelBase::getBundleDescription).map(P2Utils::createBundleIU).collect(Collectors.toList());
        ProvisioningContext context = new ProvisioningContext(agent);
        IProvisioningPlan plan = engine.createPlan(profile, context);
        for (IInstallableUnit iu : ius) {
            plan.addInstallableUnit(iu);
            plan.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules", ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)iu));
        }
        if (featureMap != null && !featureMap.isEmpty()) {
            Map<String, List<IPluginBase>> plugins = bundles.stream().flatMap(Collection::stream).map(IPluginModelBase::getPluginBase).collect(Collectors.groupingBy(m -> m.getPluginBase().getId()));
            Map<String, List<IFeature>> features = featureMap.keySet().stream().collect(Collectors.groupingBy(IIdentifiable::getId));
            for (Map.Entry<IFeature, Boolean> featureEntry : featureMap.entrySet()) {
                P2Utils.createFeatureIUs(featureEntry.getKey(), featureEntry.getValue(), plan, plugins, features);
            }
        }
        if (productInfo != null) {
            ProductAction productAction = new ProductAction(null, new IProductDescriptor(){

                public boolean useFeatures() {
                    return false;
                }

                public boolean includeLaunchers() {
                    return false;
                }

                public boolean hasFeatures() {
                    return false;
                }

                public boolean hasBundles() {
                    return false;
                }

                public String getVersion() {
                    return productInfo.version();
                }

                public String getVMArguments(String os, String arch) {
                    return null;
                }

                public String getVMArguments(String os) {
                    return null;
                }

                public String getVM(String os) {
                    return null;
                }

                public String getSplashLocation() {
                    return null;
                }

                public List<IRepositoryReference> getRepositoryEntries() {
                    return List.of();
                }

                public String getProgramArguments(String os, String arch) {
                    return null;
                }

                public String getProgramArguments(String os) {
                    return null;
                }

                public String getProductName() {
                    return productInfo.name();
                }

                public String getProductId() {
                    return null;
                }

                public ProductContentType getProductContentType() {
                    return ProductContentType.MIXED;
                }

                public File getLocation() {
                    return null;
                }

                public String getLicenseURL() {
                    return null;
                }

                public String getLicenseText() {
                    return null;
                }

                public String getLauncherName() {
                    return null;
                }

                public String getId() {
                    return productInfo.id();
                }

                public String[] getIcons(String os) {
                    return null;
                }

                public List<IVersionedId> getFeatures(int options) {
                    return List.of();
                }

                public List<IVersionedId> getFeatures() {
                    return List.of();
                }

                public Map<String, String> getConfigurationProperties(String os, String arch) {
                    return null;
                }

                public Map<String, String> getConfigurationProperties() {
                    return null;
                }

                public String getConfigIniPath(String os) {
                    return null;
                }

                public List<IVersionedId> getBundles() {
                    return List.of();
                }

                public List<BundleInfo> getBundleInfos() {
                    return List.of();
                }

                public String getApplication() {
                    return null;
                }
            }, P2_FLAVOR_DEFAULT, null);
            PublisherResult results = new PublisherResult();
            productAction.perform((IPublisherInfo)new PublisherInfo(), (IPublisherResult)results, null);
            results.query(QueryUtil.ALL_UNITS, null).forEach(arg_0 -> ((IProvisioningPlan)plan).addInstallableUnit(arg_0));
        }
        if (!(status = engine.perform(plan, phaseSet = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{"checkTrust", "collect", "configure", "unconfigure", "uninstall"}), (IProgressMonitor)new NullProgressMonitor())).isOK() && status.getSeverity() != 8) {
            throw new CoreException(status);
        }
    }

    private static String generateEnvironmentProperties() {
        StringBuilder env = new StringBuilder();
        env.append("osgi.ws=");
        env.append(TargetPlatform.getWS());
        env.append(",");
        env.append("osgi.os=");
        env.append(TargetPlatform.getOS());
        env.append(",");
        env.append("osgi.arch=");
        env.append(TargetPlatform.getOSArch());
        return env.toString();
    }

    private static void createFeatureIUs(IFeature feature, boolean root, IProvisioningPlan plan, Map<String, List<IPluginBase>> plugins, Map<String, List<IFeature>> features) {
        VersionRange range;
        Version v;
        IFeatureInfo copyright;
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setId(P2Utils.getGroupId(feature.getId()));
        Version version = Version.parseVersion((String)feature.getVersion());
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        IFeatureInfo description = feature.getFeatureInfo(0);
        if (description != null) {
            P2Utils.setProperty(iu, "org.eclipse.equinox.p2.description", description.getDescription());
            P2Utils.setProperty(iu, "org.eclipse.equinox.p2.description.url", description.getURL());
        }
        P2Utils.setProperty(iu, "org.eclipse.equinox.p2.provider", feature.getProviderName());
        IFeatureInfo license = feature.getFeatureInfo(2);
        if (license != null) {
            iu.setLicenses(new ILicense[]{MetadataFactory.createLicense((URI)P2Utils.toURIOrNull(license.getURL()), (String)license.getDescription())});
        }
        if ((copyright = feature.getFeatureInfo(1)) != null) {
            iu.setCopyright(MetadataFactory.createCopyright((URI)P2Utils.toURIOrNull(copyright.getURL()), (String)copyright.getDescription()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)iu.getId(), (VersionRange)new VersionRange(Version.emptyVersion, true, iu.getVersion(), false), (int)0, null));
        ArrayList<IRequirement> required = new ArrayList<IRequirement>();
        IFeatureObject[] iFeatureObjectArray = feature.getIncludedFeatures();
        int n = iFeatureObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild includedFeature = iFeatureObjectArray[n2];
            v = Version.parseVersion((String)includedFeature.getVersion());
            range = Version.emptyVersion.equals(v) ? features.getOrDefault(includedFeature.getId(), List.of()).stream().max(Comparator.comparing(IVersionable::getVersion)).map(IVersionable::getVersion).map(Version::parseVersion).map(P2Utils::strictVersionRange).orElse(VersionRange.emptyRange) : P2Utils.strictVersionRange(version);
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2Utils.getGroupId(includedFeature.getId()), (VersionRange)range, P2Utils.getFilter(includedFeature.getFilter(), false, includedFeature), (boolean)includedFeature.isOptional(), (boolean)false));
            ++n2;
        }
        iFeatureObjectArray = feature.getPlugins();
        n = iFeatureObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureObject plugin = iFeatureObjectArray[n2];
            v = Version.parseVersion((String)plugin.getVersion());
            range = Version.emptyVersion.equals(v) ? plugins.getOrDefault(plugin.getId(), List.of()).stream().max(Comparator.comparing(IPluginBase::getVersion)).map(IPluginBase::getVersion).map(Version::parseVersion).map(P2Utils::strictVersionRange).orElse(VersionRange.emptyRange) : P2Utils.strictVersionRange(version);
            required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)plugin.getId(), (VersionRange)range, P2Utils.getFilter(plugin.getFilter(), false, (IEnvironment)((Object)plugin)), (boolean)false, (boolean)false));
            ++n2;
        }
        iFeatureObjectArray = feature.getImports();
        n = iFeatureObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureObject fimport = iFeatureObjectArray[n2];
            VersionRange range2 = P2Utils.getRangeForImport((IFeatureImport)fimport);
            if (fimport.getType() == 1) {
                required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2Utils.getGroupId(fimport.getId()), (VersionRange)range2, P2Utils.getFilter(fimport.getFilter(), false, null), (boolean)false, (boolean)false));
            } else if (fimport.getType() == 0) {
                required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)fimport.getId(), (VersionRange)range2, P2Utils.getFilter(fimport.getFilter(), false, null), (boolean)false, (boolean)false));
            }
            ++n2;
        }
        iu.setRequirements((IRequirement[])required.toArray(IRequirement[]::new));
        iu.setTouchpointType(ITouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.setFilter(P2Utils.getFilter(null, false, feature));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (Version)iu.getVersion()));
        iu.setCapabilities((IProvidedCapability[])providedCapabilities.toArray(IProvidedCapability[]::new));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        plan.addInstallableUnit(unit);
        if (root) {
            plan.setInstallableUnitProfileProperty(unit, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
        }
    }

    public static VersionRange getRangeForImport(IFeatureImport featureImport) {
        String version = featureImport.getVersion();
        if (version != null && !version.isEmpty()) {
            try {
                org.osgi.framework.Version osgi = org.osgi.framework.Version.parseVersion((String)version);
                Version minVersion = Version.parseVersion((String)version);
                switch (featureImport.getMatch()) {
                    case 0: 
                    case 2: {
                        return new VersionRange(minVersion, true, Version.createOSGi((int)(osgi.getMajor() + 1), (int)0, (int)0), false);
                    }
                    case 1: {
                        return new VersionRange(minVersion, true, Version.createOSGi((int)osgi.getMajor(), (int)(osgi.getMinor() + 1), (int)0), false);
                    }
                    case 3: {
                        return P2Utils.strictVersionRange(minVersion);
                    }
                    case 4: {
                        return new VersionRange(minVersion, true, Version.MAX_VERSION, true);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return VersionRange.emptyRange;
    }

    private static VersionRange strictVersionRange(Version version) {
        return new VersionRange(version, true, version, true);
    }

    private static IMatchExpression<IInstallableUnit> getFilter(String baseFilter, boolean isImport, IEnvironment environment) {
        StringBuilder result = new StringBuilder();
        result.append("(&");
        if (baseFilter != null) {
            result.append(baseFilter);
        }
        if (isImport) {
            result.append("(!(org.eclipse.equinox.p2.exclude.import=true))");
        }
        if (environment != null) {
            P2Utils.expandFilter(environment.getOS(), "osgi.os", result);
            P2Utils.expandFilter(environment.getWS(), "osgi.ws", result);
            P2Utils.expandFilter(environment.getArch(), "osgi.arch", result);
            P2Utils.expandFilter(environment.getNL(), "osgi.nl", result);
        }
        if (result.length() == 2) {
            return null;
        }
        result.append(')');
        return InstallableUnit.parseFilter((String)result.toString());
    }

    private static void expandFilter(String filter, String osgiFilterValue, StringBuilder result) {
        if (filter != null && filter.length() != 0) {
            StringTokenizer token = new StringTokenizer(filter, ",");
            if (token.countTokens() == 1) {
                result.append("(" + osgiFilterValue + "=" + filter + ")");
            } else {
                result.append("(|");
                while (token.hasMoreElements()) {
                    result.append("(" + osgiFilterValue + "=" + token.nextToken() + ")");
                }
                result.append(')');
            }
        }
    }

    private static String getGroupId(String id) {
        if (id == null) {
            return null;
        }
        return id + ".feature.group";
    }

    private static URI toURIOrNull(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URIUtil.fromString((String)url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static void setProperty(MetadataFactory.InstallableUnitDescription iu, String key, String value) {
        if (value != null && !value.isEmpty()) {
            iu.setProperty(key, value);
        }
    }

    private static IInstallableUnit createBundleIU(BundleDescription bd) {
        ExportPackageDescription[] exports;
        ImportPackageSpecification[] osgiImports;
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(P2Utils.fromOSGiVersion(bd.getVersion()));
        iu.setFilter(bd.getPlatformFilter());
        iu.setTouchpointType(TOUCHPOINT_OSGI);
        boolean isFragment = bd.getHost() != null;
        BundleSpecification[] requiredBundles = bd.getRequiredBundles();
        ArrayList<IRequirement> reqsDeps = new ArrayList<IRequirement>();
        if (isFragment) {
            reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)bd.getHost().getName(), (VersionRange)P2Utils.fromOSGiVersionRange((org.osgi.framework.VersionRange)bd.getHost().getVersionRange()), null, (boolean)false, (boolean)false));
        }
        BundleSpecification[] bundleSpecificationArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)requiredBundle.getName(), (VersionRange)P2Utils.fromOSGiVersionRange((org.osgi.framework.VersionRange)requiredBundle.getVersionRange()), null, (boolean)requiredBundle.isOptional(), (boolean)false));
            ++n2;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = osgiImports = bd.getImportPackages();
        int n3 = osgiImports.length;
        n = 0;
        while (n < n3) {
            ImportPackageSpecification importSpec = importPackageSpecificationArray[n];
            String importPackageName = importSpec.getName();
            if (importPackageName.indexOf(42) == -1) {
                VersionRange versionRange = P2Utils.fromOSGiVersionRange((org.osgi.framework.VersionRange)importSpec.getVersionRange());
                boolean isOptional = importSpec.getDirective("resolution").equals("dynamic") || importSpec.getDirective("resolution").equals("optional");
                reqsDeps.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_JAVA_PACKAGE, (String)importPackageName, (VersionRange)versionRange, null, (boolean)isOptional, (boolean)false));
            }
            ++n;
        }
        iu.setRequirements(reqsDeps.toArray(new IRequirement[reqsDeps.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)bd.getSymbolicName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_BUNDLE, (String)bd.getSymbolicName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        ExportPackageDescription[] exportPackageDescriptionArray = exports = bd.getExportPackages();
        int n4 = exports.length;
        int n5 = 0;
        while (n5 < n4) {
            ExportPackageDescription export = exportPackageDescriptionArray[n5];
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_JAVA_PACKAGE, (String)export.getName(), (Version)P2Utils.fromOSGiVersion(export.getVersion())));
            ++n5;
        }
        providedCapabilities.add(BUNDLE_CAPABILITY);
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)P2Utils.fromOSGiVersion(bd.getVersion())));
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private static Version fromOSGiVersion(org.osgi.framework.Version version) {
        if (version == null) {
            return Version.MAX_VERSION;
        }
        if (version.getMajor() == Integer.MAX_VALUE && version.getMinor() == Integer.MAX_VALUE && version.getMicro() == Integer.MAX_VALUE) {
            return Version.MAX_VERSION;
        }
        return Version.createOSGi((int)version.getMajor(), (int)version.getMinor(), (int)version.getMicro(), (String)version.getQualifier());
    }

    private static VersionRange fromOSGiVersionRange(org.osgi.framework.VersionRange range) {
        if (range.equals((Object)Utils.EMPTY_RANGE)) {
            return VersionRange.emptyRange;
        }
        return new VersionRange(P2Utils.fromOSGiVersion(range.getLeft()), range.getLeftType() == '[', P2Utils.fromOSGiVersion(range.getRight()), range.getRightType() == ']');
    }

    public record ProductInfo(String id, String version, String name) {
    }
}

