/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.cloudio.internal.ui.layout;

import java.util.Random;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.cloudio.internal.ui.Word;
import org.eclipse.gef.cloudio.internal.ui.layout.ILayouter;
import org.eclipse.gef.cloudio.internal.ui.util.CloudMatrix;
import org.eclipse.gef.cloudio.internal.ui.util.RectTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DefaultLayouter
implements ILayouter {
    public static final String X_AXIS_VARIATION = "xaxis";
    public static final String Y_AXIS_VARIATION = "yaxis";
    private Random random = new Random();
    private int xAxisVariation;
    private int yAxisVariation;

    public DefaultLayouter(int i, int j) {
        this.xAxisVariation = i;
        this.yAxisVariation = j;
    }

    @Override
    public Point getInitialOffset(Word word, Rectangle cloudArea) {
        int range;
        int range2;
        int xOff = 0;
        if (this.xAxisVariation > 0 && (range2 = (cloudArea.width - word.width) / 200 * this.xAxisVariation) > 0) {
            xOff = this.random.nextInt(range2);
            if (this.random.nextBoolean()) {
                xOff = -xOff;
            }
        }
        int yOff = 0;
        if (this.yAxisVariation > 0 && (range = cloudArea.height / 200 * this.yAxisVariation) > 0) {
            yOff = this.random.nextInt(range);
            if (this.random.nextBoolean()) {
                yOff = -yOff;
            }
        }
        return new Point(xOff, yOff);
    }

    @Override
    public boolean layout(Point offset, Word word, Rectangle cloudArea, CloudMatrix mainTree) {
        Assert.isLegal((word != null ? 1 : 0) != 0, (String)"Word cannot be null!");
        Point next = new Point(-word.width / 2, -word.height / 2);
        next.x += this.random.nextInt(25);
        next.y += this.random.nextInt(25);
        double growFactor = 1.6;
        offset.x += cloudArea.width / 2;
        offset.y += cloudArea.height / 2;
        int accuracy = mainTree.getMinResolution();
        int i = 0;
        while (i < 5000) {
            double radius = Math.sqrt(next.x * next.x + next.y * next.y) + growFactor;
            double atan = Math.atan2(next.y, next.x);
            if (growFactor > 1.1) {
                growFactor -= 7.0E-4;
            }
            atan = radius < 80.0 ? (atan += 0.7) : (atan += 20.0 / radius);
            if (growFactor < 5.0E-4) {
                growFactor = 5.0E-4;
            }
            next.x = (int)(radius * Math.cos(atan));
            next.y = (int)(radius * Math.sin(atan));
            word.x = (next.x + offset.x) / accuracy * accuracy;
            word.y = (next.y + offset.y) / accuracy * accuracy;
            RectTree rt = word.tree;
            if (rt == null) break;
            rt.move(word.x, word.y);
            if (cloudArea.x <= word.x && cloudArea.y <= word.y && cloudArea.x + cloudArea.width >= word.x + word.width && cloudArea.y + cloudArea.height >= word.y + word.height && rt.fits(mainTree)) {
                rt.place(mainTree, word.id);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setOption(String optionName, Object object) {
        if (X_AXIS_VARIATION.equals(optionName)) {
            Integer value = (Integer)object;
            Assert.isLegal((value >= 0 ? 1 : 0) != 0, (String)("Parameter must be between 0 and 100 (inclusive): " + value));
            Assert.isLegal((value <= 100 ? 1 : 0) != 0, (String)("Parameter must be between 0 and 100 (inclusive): " + value));
            this.xAxisVariation = value;
            return;
        }
        if (Y_AXIS_VARIATION.equals(optionName)) {
            Integer value = (Integer)object;
            Assert.isLegal((value >= 0 ? 1 : 0) != 0, (String)("Parameter must be between 0 and 100 (inclusive): " + value));
            Assert.isLegal((value <= 100 ? 1 : 0) != 0, (String)("Parameter must be between 0 and 100 (inclusive): " + value));
            this.yAxisVariation = value;
            return;
        }
        System.err.println("Unrecognized option: " + optionName);
    }
}

