/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.ClassSourceGenerator;
import org.burningwave.core.classes.FunctionalInterfaceSourceGenerator;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfigAbst;
import org.burningwave.core.classes.UnitSourceGenerator;

public class LoadOrBuildAndDefineConfig
extends LoadOrBuildAndDefineConfigAbst<LoadOrBuildAndDefineConfig> {
    public LoadOrBuildAndDefineConfig(UnitSourceGenerator ... unitsCode) {
        super(unitsCode);
    }

    public LoadOrBuildAndDefineConfig(Collection<UnitSourceGenerator> ... unitsCodeCollections) {
        super(unitsCodeCollections);
    }

    @SafeVarargs
    public static final LoadOrBuildAndDefineConfig forUnitSourceGenerator(UnitSourceGenerator ... unitsCode) {
        return new LoadOrBuildAndDefineConfig(unitsCode);
    }

    @SafeVarargs
    public static final LoadOrBuildAndDefineConfig forUnitSourceGenerator(Collection<UnitSourceGenerator> ... unitsCode) {
        return new LoadOrBuildAndDefineConfig(unitsCode);
    }

    public static class ForCodeExecutorAbst<C extends ForCodeExecutorAbst<C>>
    extends LoadOrBuildAndDefineConfigAbst<C> {
        BodySourceGenerator body;

        ForCodeExecutorAbst(String executorName, BodySourceGenerator bodySG) {
            super(UnitSourceGenerator.create(StaticComponentContainer.Classes.retrievePackageName(executorName)).addClass(FunctionalInterfaceSourceGenerator.create().generateExecutor(executorName, bodySG)));
            this.body = bodySG;
            this.modifyCompilationConfig(compileConfig -> compileConfig.storeCompiledClasses(false));
        }

        public C setSimpleName(String simpleName) {
            UnitSourceGenerator uSG = (UnitSourceGenerator)this.unitSourceGenerators.iterator().next();
            ClassSourceGenerator cSG = uSG.getAllClasses().values().iterator().next();
            cSG.getTypeDeclaration().setSimpleName(simpleName);
            return (C)this;
        }

        public C setName(String name) {
            UnitSourceGenerator uSG = (UnitSourceGenerator)this.unitSourceGenerators.iterator().next();
            uSG.setPackageName(StaticComponentContainer.Classes.retrievePackageName(name));
            ClassSourceGenerator cSG = uSG.getAllClasses().values().iterator().next();
            cSG.getTypeDeclaration().setSimpleName(StaticComponentContainer.Classes.retrieveSimpleName(name));
            return (C)this;
        }

        String getExecutorName() {
            UnitSourceGenerator uSG = (UnitSourceGenerator)this.unitSourceGenerators.iterator().next();
            ClassSourceGenerator cSG = uSG.getAllClasses().values().iterator().next();
            return uSG.getPackageName() + "." + cSG.getTypeDeclaration().getSimpleName();
        }

        BodySourceGenerator getBody() {
            return this.body;
        }
    }
}

