/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilterSortedNumericDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.internal.hppc.IntArrayList;

public class OrdinalMappingLeafReader
extends FilterLeafReader {
    private final int[] ordinalMap;
    private final Set<String> facetFields;

    public OrdinalMappingLeafReader(LeafReader in, int[] ordinalMap, FacetsConfig srcConfig) {
        super(in);
        this.ordinalMap = ordinalMap;
        this.facetFields = new HashSet<String>();
        for (FacetsConfig.DimConfig dc : srcConfig.getDimConfigs().values()) {
            this.facetFields.add(dc.indexFieldName);
        }
        this.facetFields.add(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        SortedNumericDocValues original = this.in.getSortedNumericDocValues(field);
        if (original != null && this.facetFields.contains(field)) {
            return new OrdinalMappingSortedNumericDocValues(original);
        }
        return original;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private class OrdinalMappingSortedNumericDocValues
    extends FilterSortedNumericDocValues {
        private final IntArrayList currentValues;
        private int currIndex;

        OrdinalMappingSortedNumericDocValues(SortedNumericDocValues in) {
            super(in);
            this.currentValues = new IntArrayList(32);
        }

        public boolean advanceExact(int target) throws IOException {
            boolean result = this.in.advanceExact(target);
            if (result) {
                this.reloadValues();
            }
            return result;
        }

        public int advance(int target) throws IOException {
            int result = this.in.advance(target);
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        public int nextDoc() throws IOException {
            int result = this.in.nextDoc();
            if (result != Integer.MAX_VALUE) {
                this.reloadValues();
            }
            return result;
        }

        public int docValueCount() {
            return this.currentValues.elementsCount;
        }

        private void reloadValues() throws IOException {
            this.currIndex = 0;
            this.currentValues.clear();
            for (int i = 0; i < this.in.docValueCount(); ++i) {
                int originalOrd = Math.toIntExact(this.in.nextValue());
                this.currentValues.add(OrdinalMappingLeafReader.this.ordinalMap[originalOrd]);
            }
            Arrays.sort(this.currentValues.buffer, 0, this.currentValues.elementsCount);
        }

        public long nextValue() {
            assert (this.currIndex < this.currentValues.size());
            int actual = this.currentValues.get(this.currIndex);
            ++this.currIndex;
            return actual;
        }
    }
}

