/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.zip;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModelFactory;
import org.eclipse.rcptt.core.persistence.zip.PersistenceZipModel;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;

public class PersistenceZipModelFactory
implements IPersistenceModelFactory {
    @Override
    public IPersistenceModel createModel(Resource resource) {
        return new PersistenceZipModel(resource);
    }

    @Override
    public boolean isSupported(InputStream contents) {
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(contents));
            int entries = 0;
            boolean hasMeta = false;
            while ((entry = zin.getNextEntry()) != null) {
                ++entries;
                if (!entry.getName().equalsIgnoreCase(".q7.content")) continue;
                hasMeta = true;
            }
            boolean bl = hasMeta && entries > 0;
            return bl;
        }
        catch (ZipException zex) {
            return false;
        }
        catch (Throwable e) {
            RcpttPlugin.log(e);
        }
        finally {
            FileUtil.safeClose((Closeable)contents);
        }
        return false;
    }

    @Override
    public boolean isSupported(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry entry = zipFile.getEntry(".q7.content");
            if (entry != null) {
                return true;
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

