/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.rcptt.ui.editors.ecl.DocumentCharacterIterator;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclWordIterator;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclTextNavigationAction;

abstract class NextSubWordAction
extends EclTextNavigationAction {
    protected EclWordIterator fIterator = new EclWordIterator();

    protected NextSubWordAction(EclEditor eclEditor, int code) {
        super(eclEditor, eclEditor.doGetSourceViewer().getTextWidget(), code);
    }

    @Override
    public void internalRun(TextViewer viewer) {
        IDocument document = viewer.getDocument();
        try {
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = this.eclEditor.doWidgetOffset2ModelOffset(viewer, viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(viewer, position);
            if (this.eclEditor.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                super.run();
            } else if (next != -1) {
                this.setCaretPosition(viewer, next);
                viewer.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected int findNextPosition(TextViewer viewer, int position) {
        int widget = -1;
        int next = position;
        while (next != -1 && widget == -1) {
            if ((next = this.fIterator.following(next)) == -1) continue;
            widget = this.eclEditor.doModelOffset2WidgetOffset(viewer, next);
        }
        IDocument document = viewer.getDocument();
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
        if (model != null) {
            LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
            if (linkedPosition != null) {
                int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                if (position != linkedPositionEnd && linkedPositionEnd < next) {
                    next = linkedPositionEnd;
                }
            } else {
                int nextLinkedPositionOffset;
                LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                    next = nextLinkedPositionOffset;
                }
            }
        }
        return next;
    }

    protected abstract void setCaretPosition(TextViewer var1, int var2);
}

