/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.operations.RepeatWith;
import org.eclipse.rcptt.ecl.parser.EclCoreParser;
import org.eclipse.rcptt.ecl.runtime.CoreUtils;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IPipe;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class RepeatWithService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof RepeatWith)) {
            return Status.CANCEL_STATUS;
        }
        RepeatWith repeatWith = (RepeatWith)command;
        Command todo = repeatWith.getCommand();
        ISession session = context.getSession();
        for (Object cmd : repeatWith.getCommands()) {
            IPipe pipe;
            Command prefix = RepeatWithService.getCommand(cmd);
            IStatus status = session.execute(prefix, null, pipe = session.createPipe()).waitFor();
            if (!status.isOK()) {
                return status;
            }
            IPipe output = session.createPipe();
            status = session.execute(todo, pipe, output).waitFor();
            if (!status.isOK()) {
                return status;
            }
            for (Object obj : CoreUtils.readPipeContent((IPipe)output)) {
                context.getOutput().write(obj);
            }
        }
        return Status.OK_STATUS;
    }

    private static Command getCommand(Object cmd) throws CoreException {
        if (cmd instanceof Command) {
            return (Command)cmd;
        }
        if (cmd instanceof EclString) {
            return EclCoreParser.newCommand((String)((EclString)cmd).getValue());
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.operations", String.format("Cannot convert value of type %s to command", cmd.getClass().getName())));
    }
}

