/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.RemoteRepositoryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.ResourceHandle;
import aQute.bnd.version.Version;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.bnd.ui.model.repo.ResourceProvider;
import org.eclipse.pde.bnd.ui.model.repo.VersionFinder;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.ExpressionCombiner;
import org.osgi.service.repository.OrExpression;
import org.osgi.service.repository.Repository;
import org.osgi.service.repository.RequirementExpression;
import org.osgi.util.promise.Promise;

public abstract class RepositoryEntry
implements IAdaptable,
ResourceProvider {
    private final RepositoryPlugin repo;
    private final String bsn;
    private final VersionFinder versionFinder;

    protected RepositoryEntry(RepositoryPlugin repo, String bsn, VersionFinder versionFinder) {
        this.repo = repo;
        this.bsn = bsn;
        this.versionFinder = versionFinder;
    }

    public final RepositoryPlugin getRepo() {
        return this.repo;
    }

    public final String getBsn() {
        return this.bsn;
    }

    public <T> T getAdapter(Class<T> adapter) {
        boolean adaptable;
        boolean bl = adaptable = IFile.class.equals(adapter) || File.class.equals(adapter) || URI.class.equals(adapter);
        if (!adaptable) {
            return null;
        }
        if (IFile.class.equals(adapter)) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File file = this.getFile(false);
            return (T)(file != null ? root.getFileForLocation((IPath)new Path(file.getAbsolutePath())) : null);
        }
        if (File.class.equals(adapter)) {
            return (T)this.getFile(false);
        }
        if (URI.class.equals(adapter)) {
            File file = this.getFile(false);
            return (T)(file != null ? file.toURI() : null);
        }
        return null;
    }

    public final boolean isLocal() {
        boolean result = true;
        try {
            if (this.repo instanceof RemoteRepositoryPlugin) {
                ResourceHandle handle = ((RemoteRepositoryPlugin)this.repo).getHandle(this.bsn, this.versionFinder.versionSpec, this.versionFinder.strategy, Collections.emptyMap());
                ResourceHandle.Location location = handle.getLocation();
                result = location == ResourceHandle.Location.local || location == ResourceHandle.Location.remote_cached;
            }
        }
        catch (Exception e) {
            ILog.get().error(MessageFormat.format("Failed to query repository {0} for bundle {1} version {2}.", this.repo.getName(), this.bsn, this.versionFinder), (Throwable)e);
        }
        return result;
    }

    public final File getFile(boolean forceDownload) {
        Version version;
        block7: {
            try {
                if (this.repo instanceof RemoteRepositoryPlugin) {
                    ResourceHandle handle = ((RemoteRepositoryPlugin)this.repo).getHandle(this.bsn, this.versionFinder.versionSpec, this.versionFinder.strategy, Collections.emptyMap());
                    switch (handle.getLocation()) {
                        case local: 
                        case remote_cached: {
                            return handle.request();
                        }
                    }
                    return forceDownload ? handle.request() : null;
                }
                version = this.versionFinder.findVersion();
                if (version != null) break block7;
                return null;
            }
            catch (Exception e) {
                ILog.get().error(MessageFormat.format("Failed to query repository {0} for bundle {1} version {2}.", this.repo.getName(), this.bsn, this.versionFinder), Exceptions.unrollCause((Throwable)e, InvocationTargetException.class));
                return null;
            }
        }
        return this.repo.get(this.bsn, version, Collections.emptyMap(), new RepositoryPlugin.DownloadListener[0]);
    }

    @Override
    public Resource getResource() {
        RepositoryPlugin repositoryPlugin = this.getRepo();
        try {
            if (repositoryPlugin instanceof Repository) {
                Repository repository = (Repository)repositoryPlugin;
                ExpressionCombiner combiner = repository.getExpressionCombiner();
                RequirementBuilder identBuilder = new RequirementBuilder("osgi.identity");
                identBuilder.addFilter("osgi.identity", this.bsn, this.versionFinder.findVersion().toString(), null);
                RequirementBuilder infoBuilder = new RequirementBuilder("bnd.info");
                infoBuilder.addFilter("name", this.bsn, this.versionFinder.findVersion().toString(), null);
                OrExpression expression = combiner.or((RequirementExpression)combiner.identity((Requirement)identBuilder.buildSyntheticRequirement()), (RequirementExpression)combiner.identity((Requirement)infoBuilder.buildSyntheticRequirement()));
                Promise promise = repository.findProviders((RequirementExpression)expression);
                Throwable failure = promise.getFailure();
                if (failure != null) {
                    throw Exceptions.duck((Throwable)failure);
                }
                return ((Collection)promise.getValue()).stream().findFirst().orElse(null);
            }
            File file = repositoryPlugin.get(this.bsn, this.versionFinder.findVersion(), null, new RepositoryPlugin.DownloadListener[0]);
            if (file != null && file.exists()) {
                ResourceBuilder rb = new ResourceBuilder();
                rb.addFile(file, file.toURI());
                return rb.build();
            }
        }
        catch (Exception e) {
            throw Exceptions.duck((Throwable)e);
        }
        return null;
    }
}

