/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter {
    protected ISearchQuery fQuery;

    public SearchResult(ISearchQuery query) {
        this.fQuery = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public String getLabel() {
        int numMatches = this.getMatchCount();
        return this.fQuery.getLabel() + " - " + numMatches + " " + (numMatches == 1 ? PDEUIMessages.SearchResult_match : PDEUIMessages.SearchResult_matches);
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PDEPluginImages.DESC_PSEARCH_OBJ;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IPluginObject) {
            return this.isMatchContained(editor, (IPluginObject)element);
        }
        if (element instanceof IFeaturePlugin) {
            return this.isMatchContained(editor, (IFeaturePlugin)element);
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        Object[] objects;
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] objectArray = objects = result.getElements();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin object;
            IPluginObject object2;
            Object o = objectArray[n2];
            if (o instanceof IPluginObject && this.isMatchContained(editor, object2 = (IPluginObject)o)) {
                Match[] matches;
                Match[] matchArray = matches = this.getMatches(object2);
                int n3 = matches.length;
                int n4 = 0;
                while (n4 < n3) {
                    Match matche = matchArray[n4];
                    IDocument document = this.getDocument(editor, matche);
                    if (document != null) {
                        list.add(ManifestEditorOpener.findExactMatch(document, matche, editor));
                    }
                    ++n4;
                }
            }
            if (o instanceof IFeaturePlugin && this.isMatchContained(editor, object = (IFeaturePlugin)o)) {
                Collections.addAll(list, this.getMatches(object));
            }
            ++n2;
        }
        return list.toArray(new Match[list.size()]);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    protected boolean isMatchContained(IEditorPart editor, IPluginObject object) {
        return this.isMatchContained(editor, object.getModel().getUnderlyingResource(), object.getModel().getInstallLocation());
    }

    protected boolean isMatchContained(IEditorPart editor, IFeaturePlugin object) {
        return this.isMatchContained(editor, object.getModel().getUnderlyingResource(), object.getModel().getInstallLocation());
    }

    protected boolean isMatchContained(IEditorPart editor, IResource underlyingResource, String installLocation) {
        IResource objectResource;
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource != null && (objectResource = underlyingResource) != null) {
            return resource.getProject().equals((Object)objectResource.getProject());
        }
        File file = (File)editor.getEditorInput().getAdapter(File.class);
        if (file != null) {
            IPath path = IPath.fromOSString((String)installLocation);
            IPath filePath = null;
            filePath = "MANIFEST.MF".equals(file.getName()) ? IPath.fromOSString((String)file.getParentFile().getParent()) : (file.getName().endsWith("jar") ? IPath.fromOSString((String)file.getPath()) : IPath.fromOSString((String)file.getParent()));
            return path.equals((Object)filePath);
        }
        return false;
    }

    protected IDocument getDocument(IEditorPart editor, Match match) {
        IDocument document = null;
        if (editor instanceof ISearchEditorAccess) {
            document = ((ISearchEditorAccess)editor).getDocument(match);
        } else if (editor instanceof ITextEditor) {
            document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
        }
        return document;
    }
}

