/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.transport.ecf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.transport.ecf.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class RepositoryStatusHelper {
    protected static final String SERVER_REDIRECT = "Server redirected too many times";

    public static IStatus createStatus(String nlsMessage, Object arg) {
        return RepositoryStatusHelper.createExceptionStatus(null, nlsMessage, new Object[]{arg});
    }

    public static IStatus createStatus(String nlsMessage, Object arg1, Object arg2) {
        return RepositoryStatusHelper.createExceptionStatus(null, nlsMessage, new Object[]{arg1, arg2});
    }

    public static IStatus createStatus(String nlsMessage, Object arg1, Object arg2, Object arg3) {
        return RepositoryStatusHelper.createExceptionStatus(null, nlsMessage, new Object[]{arg1, arg2, arg3});
    }

    public static IStatus createStatus(String nlsMessage, Object[] args) {
        return RepositoryStatusHelper.createExceptionStatus(null, nlsMessage, args);
    }

    public static IStatus createStatus(String nlsMessage) {
        return RepositoryStatusHelper.createExceptionStatus(null, nlsMessage, new Object[0]);
    }

    public static IStatus createExceptionStatus(Throwable cause) {
        return cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, "org.eclipse.equinox.p2.transport.ecf", 0, cause.getMessage(), cause);
    }

    public static IStatus createExceptionStatus(Throwable cause, String nlsMessage, Object[] args) {
        if (args != null && args.length > 0) {
            nlsMessage = NLS.bind((String)nlsMessage, (Object[])args);
        }
        return new Status(4, "org.eclipse.equinox.p2.transport.ecf", 0, nlsMessage, cause);
    }

    public static IStatus createExceptionStatus(Throwable cause, String nlsMessage, Object arg1, Object arg2, Object arg3) {
        return RepositoryStatusHelper.createExceptionStatus(cause, nlsMessage, new Object[]{arg1, arg2, arg3});
    }

    public static IStatus createExceptionStatus(Throwable cause, String nlsMessage, Object arg1, Object arg2) {
        return RepositoryStatusHelper.createExceptionStatus(cause, nlsMessage, new Object[]{arg1, arg2});
    }

    public static IStatus createExceptionStatus(Throwable cause, String nlsMessage, Object arg1) {
        return RepositoryStatusHelper.createExceptionStatus(cause, nlsMessage, new Object[]{arg1});
    }

    public static IStatus createExceptionStatus(Throwable cause, String nlsMessage) {
        return RepositoryStatusHelper.createExceptionStatus(cause, nlsMessage, new Object[0]);
    }

    public static void deeplyPrint(Throwable e, PrintStream strm, boolean stackTrace) {
        RepositoryStatusHelper.deeplyPrint(e, strm, stackTrace, 0);
    }

    public static CoreException fromMessage(String nlsMessage, Object[] args) {
        return RepositoryStatusHelper.fromExceptionMessage(null, nlsMessage, args);
    }

    public static CoreException fromMessage(String nlsMessage, Object arg1) {
        return RepositoryStatusHelper.fromExceptionMessage(null, nlsMessage, new Object[]{arg1});
    }

    public static CoreException fromMessage(String nlsMessage, Object arg1, Object arg2) {
        return RepositoryStatusHelper.fromExceptionMessage(null, nlsMessage, new Object[]{arg1, arg2});
    }

    public static CoreException fromMessage(String nlsMessage, Object arg1, Object arg2, Object arg3) {
        return RepositoryStatusHelper.fromExceptionMessage(null, nlsMessage, new Object[]{arg1, arg2, arg3});
    }

    public static CoreException fromMessage(String nlsMessage) {
        return RepositoryStatusHelper.fromExceptionMessage(null, nlsMessage, new Object[0]);
    }

    public static CoreException fromExceptionMessage(Throwable cause, String nlsMessage, Object[] args) {
        CoreException ce = new CoreException(RepositoryStatusHelper.createExceptionStatus(cause, nlsMessage, args));
        if (cause != null) {
            ce.initCause(cause);
        }
        return ce;
    }

    public static CoreException fromExceptionMessage(Throwable cause, String nlsMessage, Object arg1, Object arg2, Object arg3) {
        return RepositoryStatusHelper.fromExceptionMessage(cause, nlsMessage, new Object[]{arg1, arg2, arg3});
    }

    public static CoreException fromExceptionMessage(Throwable cause, String nlsMessage, Object arg1, Object arg2) {
        return RepositoryStatusHelper.fromExceptionMessage(cause, nlsMessage, new Object[]{arg1, arg2});
    }

    public static CoreException fromExceptionMessage(Throwable cause, String nlsMessage, Object arg1) {
        return RepositoryStatusHelper.fromExceptionMessage(cause, nlsMessage, new Object[]{arg1});
    }

    public static CoreException fromExceptionMessage(Throwable cause, String nlsMessage) {
        return RepositoryStatusHelper.fromExceptionMessage(cause, nlsMessage, new Object[0]);
    }

    public static Throwable unwind(Throwable t) {
        String msg;
        Throwable cause;
        Class<?> tc;
        while (!((tc = t.getClass()) != RuntimeException.class && tc != InvocationTargetException.class && tc != IOException.class && tc != ExecutionException.class || (cause = t.getCause()) == null || (msg = t.getMessage()) != null && !msg.equals(cause.toString()))) {
            t = cause;
        }
        return t;
    }

    public static CoreException unwindCoreException(CoreException exception) {
        IStatus status = exception.getStatus();
        while (status != null && status.getException() instanceof CoreException) {
            exception = (CoreException)status.getException();
            status = exception.getStatus();
        }
        return exception;
    }

    public static CoreException wrap(IStatus status) {
        CoreException e = new CoreException(status);
        Throwable t = status.getException();
        if (t != null) {
            e.initCause(t);
        }
        return e;
    }

    public static CoreException wrap(Throwable t) {
        if ((t = RepositoryStatusHelper.unwind(t)) instanceof CoreException) {
            return RepositoryStatusHelper.unwindCoreException((CoreException)t);
        }
        if (t instanceof OperationCanceledException || t instanceof InterruptedException) {
            return new CoreException(Status.CANCEL_STATUS);
        }
        String msg = t.toString();
        return RepositoryStatusHelper.fromExceptionMessage(t, msg);
    }

    private static void appendLevelString(PrintStream strm, int level) {
        if (level > 0) {
            strm.print("[0");
            int idx = 1;
            while (idx < level) {
                strm.print('.');
                strm.print(level);
                ++idx;
            }
            strm.print(']');
        }
    }

    private static void deeplyPrint(CoreException ce, PrintStream strm, boolean stackTrace, int level) {
        RepositoryStatusHelper.appendLevelString(strm, level);
        if (stackTrace) {
            ce.printStackTrace(strm);
        }
        RepositoryStatusHelper.deeplyPrint(ce.getStatus(), strm, stackTrace, level);
    }

    private static void deeplyPrint(IStatus status, PrintStream strm, boolean stackTrace, int level) {
        RepositoryStatusHelper.appendLevelString(strm, level);
        String msg = status.getMessage();
        strm.println(msg);
        Throwable cause = status.getException();
        if (cause != null) {
            strm.print("Caused by: ");
            if (stackTrace || !msg.equals(cause.getMessage()) && !msg.equals(cause.toString())) {
                RepositoryStatusHelper.deeplyPrint(cause, strm, stackTrace, level);
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                RepositoryStatusHelper.deeplyPrint(child, strm, stackTrace, level + 1);
                ++n2;
            }
        }
    }

    private static void deeplyPrint(Throwable t, PrintStream strm, boolean stackTrace, int level) {
        if (t instanceof CoreException) {
            RepositoryStatusHelper.deeplyPrint((CoreException)t, strm, stackTrace, level);
        } else {
            RepositoryStatusHelper.appendLevelString(strm, level);
            if (stackTrace) {
                t.printStackTrace(strm);
            } else {
                strm.println(t.toString());
                Throwable cause = t.getCause();
                if (cause != null) {
                    strm.print("Caused by: ");
                    RepositoryStatusHelper.deeplyPrint(cause, strm, stackTrace, level);
                }
            }
        }
    }

    public static void checkJREHttpClientRequired(Throwable t) throws JREHttpClientRequiredException {
        if (t instanceof IncomingFileTransferException ? ((IncomingFileTransferException)t).getErrorCode() == 477 : t instanceof BrowseFileTransferException && ((BrowseFileTransferException)t).getErrorCode() == 477) {
            throw new JREHttpClientRequiredException();
        }
    }

    public static void checkPermissionDenied(Throwable t) throws AuthenticationFailedException {
        if (t instanceof IncomingFileTransferException) {
            if (((IncomingFileTransferException)t).getErrorCode() == 401) {
                throw new AuthenticationFailedException();
            }
            status = ((IncomingFileTransferException)t).getStatus();
            t = status == null ? t : status.getException();
        } else if (t instanceof BrowseFileTransferException) {
            if (((BrowseFileTransferException)t).getErrorCode() == 401) {
                throw new AuthenticationFailedException();
            }
            status = ((BrowseFileTransferException)t).getStatus();
            Throwable throwable = t = status == null ? t : status.getException();
        }
        if (t == null || !(t instanceof IOException)) {
            return;
        }
        String m = t.getMessage();
        if (m != null && (m.contains(" 401 ") || m.contains(SERVER_REDIRECT))) {
            throw new AuthenticationFailedException();
        }
        if ("org.apache.commons.httpclient.RedirectException".equals(t.getClass().getName())) {
            throw new AuthenticationFailedException();
        }
    }

    public static void checkFileNotFound(Throwable t, URI toDownload) throws FileNotFoundException {
        IncomingFileTransferException e;
        if (t instanceof IncomingFileTransferException && ((e = (IncomingFileTransferException)t).getErrorCode() == 404 || e.getErrorCode() == 403 || e.getErrorCode() == 300)) {
            throw new FileNotFoundException(toDownload.toString());
        }
        if (t instanceof BrowseFileTransferException && ((e = (BrowseFileTransferException)t).getErrorCode() == 404 || e.getErrorCode() == 403 || e.getErrorCode() == 300)) {
            throw new FileNotFoundException(toDownload.toString());
        }
        if (t instanceof FileNotFoundException) {
            throw (FileNotFoundException)t;
        }
        if (t instanceof CoreException) {
            Throwable e2;
            IStatus status = ((CoreException)t).getStatus();
            Throwable throwable = e2 = status == null ? null : status.getException();
            if (e2 instanceof FileNotFoundException) {
                throw (FileNotFoundException)e2;
            }
        }
    }

    public static IStatus malformedAddressStatus(String address, Throwable t) {
        return new Status(4, "org.eclipse.equinox.p2.transport.ecf", 1006, NLS.bind((String)Messages.exception_malformedRepoURI, (Object)address), t);
    }
}

