/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.SystemReader;

public class RepositoryFinder {
    private final IProject proj;
    private final List<RepositoryMapping> results = new ArrayList<RepositoryMapping>();
    private final Set<File> gitdirs = new HashSet<File>();
    private final Set<File> ceilingDirectories = new HashSet<File>();
    private boolean findInChildren = true;

    public RepositoryFinder(IProject p) {
        this.proj = p;
        String ceilingDirectoriesVar = SystemReader.getInstance().getenv("GIT_CEILING_DIRECTORIES");
        if (ceilingDirectoriesVar != null) {
            String[] stringArray = ceilingDirectoriesVar.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.ceilingDirectories.add(new File(path));
                ++n2;
            }
        }
    }

    public void setFindInChildren(boolean findInChildren) {
        this.findInChildren = findInChildren;
    }

    public List<RepositoryMapping> find(IProgressMonitor m) throws CoreException {
        return this.find(m, false);
    }

    public List<RepositoryMapping> find(IProgressMonitor m, boolean searchLinkedFolders) throws CoreException {
        this.find(m, (IContainer)this.proj, searchLinkedFolders);
        return this.results;
    }

    private void find(IProgressMonitor m, IContainer c, boolean searchLinkedFolders) throws CoreException {
        IResource[] children;
        if (!searchLinkedFolders && c.isLinked()) {
            return;
        }
        IPath loc = c.getLocation();
        if (loc == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)101);
        progress.subTask(CoreText.RepositoryFinder_finding);
        File fsLoc = loc.toFile();
        assert (fsLoc.isAbsolute());
        if (c instanceof IProject) {
            this.findInDirectoryAndParents(c, fsLoc);
        } else {
            this.findInDirectory(c, fsLoc);
        }
        progress.worked(1);
        if (this.findInChildren && (children = c.members()) != null && children.length > 0) {
            progress.setWorkRemaining(children.length);
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource o = iResourceArray[n2];
                if (o instanceof IContainer && !o.getName().equals(".git")) {
                    this.find((IProgressMonitor)progress.newChild(1), (IContainer)o, searchLinkedFolders);
                } else {
                    progress.worked(1);
                }
                ++n2;
            }
        }
    }

    private void findInDirectoryAndParents(IContainer container, File startPath) {
        File path = startPath;
        while (path != null && !this.ceilingDirectories.contains(path)) {
            this.findInDirectory(container, path);
            path = path.getParentFile();
        }
    }

    private void findInDirectory(IContainer container, File path) {
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Looking at candidate dir: " + String.valueOf(path));
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File parent = path.getParentFile();
        if (parent != null) {
            builder.addCeilingDirectory(parent);
        }
        builder.findGitDir(path);
        File gitDir = builder.getGitDir();
        if (gitDir != null) {
            this.register(container, gitDir);
        }
    }

    private void register(IContainer c, File gitdir) {
        File f = gitdir.getAbsoluteFile();
        if (this.gitdirs.contains(f)) {
            return;
        }
        this.gitdirs.add(f);
        RepositoryMapping mapping = RepositoryMapping.create(c, f);
        if (mapping != null) {
            this.results.add(mapping);
        }
    }
}

