/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class JavaProcessors {
    public static String[] computeAffectedNatures(IJavaElement element) throws CoreException {
        IMember member;
        if (element instanceof IMember && JdtFlags.isPrivate(member = (IMember)element)) {
            return element.getJavaProject().getProject().getDescription().getNatureIds();
        }
        IJavaProject project = element.getJavaProject();
        return ResourceProcessors.computeAffectedNatures((IResource)project.getProject());
    }

    public static String[] computeAffectedNaturs(IJavaElement[] elements) throws CoreException {
        HashSet<String> result = new HashSet<String>();
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            String[] natures = JavaProcessors.computeAffectedNatures(element);
            result.addAll(Arrays.asList(natures));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private JavaProcessors() {
    }
}

