/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractFilteredViewerComposite<T extends ViewerFilter>
extends Composite {
    private ViewerFilter patternFilter;
    protected Text filterText;
    protected Composite filterComposite;
    protected boolean showFilterControls;
    protected String initialText = "";
    protected Composite parent;
    private final long refreshJobDelayInMillis;

    public AbstractFilteredViewerComposite(Composite parent, int style, long refreshJobDelayInMillis) {
        super(parent, style);
        this.refreshJobDelayInMillis = refreshJobDelayInMillis;
    }

    protected void init(int style, T filter) {
        this.patternFilter = filter;
        this.createControl(this.parent, style);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite parent, int style) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(4, 4, true, true));
        }
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout();
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        return parent;
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = AbstractFilteredViewerComposite.this.filterText.getDisplay();
                display.asyncExec(() -> {
                    if (!AbstractFilteredViewerComposite.this.filterText.isDisposed() && AbstractFilteredViewerComposite.this.getInitialText().equals(AbstractFilteredViewerComposite.this.filterText.getText().trim())) {
                        AbstractFilteredViewerComposite.this.filterText.selectAll();
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                if (AbstractFilteredViewerComposite.this.filterText.getText().equals(AbstractFilteredViewerComposite.this.initialText)) {
                    AbstractFilteredViewerComposite.this.setFilterText("");
                    AbstractFilteredViewerComposite.this.textChanged();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (AbstractFilteredViewerComposite.this.filterText.getText().equals(AbstractFilteredViewerComposite.this.initialText)) {
                    AbstractFilteredViewerComposite.this.setFilterText("");
                    AbstractFilteredViewerComposite.this.textChanged();
                }
            }
        });
        this.filterText.addModifyListener(e -> this.textChanged());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)gridData);
    }

    protected abstract Text doCreateFilterText(Composite var1);

    protected abstract void textChanged();

    protected long getRefreshJobDelay() {
        return this.refreshJobDelayInMillis;
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String filterText) {
        if (this.filterText != null) {
            this.filterText.setText(filterText);
            this.selectAll();
        }
    }

    public ViewerFilter getPatternFilter() {
        return this.patternFilter;
    }

    public abstract StructuredViewer getViewer();

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(() -> {
                    if (!this.filterText.isDisposed() && this.filterText.isFocusControl()) {
                        this.setFilterText(this.initialText);
                        this.textChanged();
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }
}

